/*
 * Decompiled with CFR 0.152.
 */
package com.rfid.trans188;

import com.rfid.trans188.BaseReader;
import com.rfid.trans188.ReaderParameter;
import com.rfid.trans188.TagCallback;

public class UHFLib {
    private BaseReader reader = null;
    private ReaderParameter param = new ReaderParameter();
    private volatile boolean mWorking = true;
    private volatile Thread mThread = null;
    private byte[] pOUcharIDList = new byte[25600];
    private volatile int NoCardCOunt = 0;
    private int mType = 0;
    private long beginTime = 0L;

    public UHFLib(int type) {
        this.param.ComAddr = (byte)-1;
        this.param.ScanTime = 1;
        this.param.Session = 0;
        this.param.QValue = 4;
        this.param.TidLen = 0;
        this.param.TidPtr = 0;
        this.param.Antenna = 1;
        this.mType = type;
        this.reader = new BaseReader(type);
    }

    public void SetCallBack(TagCallback callback) {
        this.reader.SetCallBack(callback);
    }

    public int Connect(String ComPort, int BaudRate) {
        int result = this.reader.Connect(ComPort, BaudRate, this.mType);
        return result;
    }

    public int DisConnect() {
        int result = this.reader.DisConnect();
        return result;
    }

    public void SetInventoryPatameter(ReaderParameter param) {
        this.param = param;
    }

    public ReaderParameter GetInventoryPatameter() {
        return this.param;
    }

    public int GetUHFInformation(byte[] Version2, byte[] Power, byte[] band, byte[] MaxFre, byte[] MinFre, byte[] ScanTime) {
        byte[] ReaderType = new byte[1];
        byte[] TrType = new byte[1];
        byte[] OutputRep = new byte[1];
        byte[] CheckAnt = new byte[1];
        byte[] ComAddr = new byte[]{-1};
        int result = this.reader.GetReaderInformation(ComAddr, Version2, ReaderType, TrType, band, MaxFre, MinFre, Power, ScanTime);
        if (result == 0) {
            this.param.ComAddr = ComAddr[0];
        }
        return result;
    }

    public int SetRfPower(int Power) {
        int result = this.reader.SetRfPower(this.param.ComAddr, (byte)Power);
        return result;
    }

    public int SetInventoryScanTime(int scantime) {
        return this.reader.SetInventoryScanTime(this.param.ComAddr, (byte)scantime);
    }

    public int SetRegion(int band, int maxfre, int minfre) {
        int result = this.reader.SetRegion(this.param.ComAddr, band, maxfre, minfre);
        return result;
    }

    public int SetAddress(int Addr) {
        int result = this.reader.SetAddress(this.param.ComAddr, (byte)Addr);
        if (result == 0) {
            this.param.ComAddr = (byte)Addr;
        }
        return result;
    }

    public int SetRelay(int RelayStatus) {
        int result = this.reader.SetRelay(this.param.ComAddr, (byte)RelayStatus);
        return result;
    }

    public int SetWorkMode(byte[] Parameter) {
        int result = this.reader.SetWorkMode(this.param.ComAddr, Parameter);
        return result;
    }

    public int GetWorkMode(byte[] Parameter) {
        int result = this.reader.GetWorkMode(this.param.ComAddr, Parameter);
        return result;
    }

    public String ReadDataByEPC(String EPCStr, byte Mem, byte WordPtr, byte Num, byte[] Password) {
        byte[] Errorcode;
        byte[] Data;
        byte[] EPC;
        if (EPCStr.length() % 4 != 0) {
            return "FF";
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        int result = this.reader.ReadData_G2(this.param.ComAddr, ENum, EPC = this.reader.hexStringToBytes(EPCStr), Mem, WordPtr, Num, Password, Data = new byte[Num * 2], Errorcode = new byte[1]);
        if (result == 0) {
            return this.reader.bytesToHexString(Data, 0, Data.length);
        }
        return "";
    }

    public int WriteDataByEPC(String EPCStr, byte Mem, byte WordPtr, byte[] Password, String wdata) {
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        if (wdata.length() % 4 != 0) {
            return 255;
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        byte WNum = (byte)(wdata.length() / 4);
        byte[] EPC = this.reader.hexStringToBytes(EPCStr);
        byte[] data = this.reader.hexStringToBytes(wdata);
        byte[] Errorcode = new byte[1];
        return this.reader.WriteData_G2(this.param.ComAddr, WNum, ENum, EPC, Mem, WordPtr, data, Password, Errorcode);
    }

    public int WriteEPC(String EPCStr, byte[] Password) {
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        byte WNum = (byte)(EPCStr.length() / 4);
        byte[] EPC = new byte[12];
        byte[] Errorcode = new byte[1];
        String wdata = EPCStr;
        byte[] data = this.reader.hexStringToBytes(wdata);
        return this.reader.WriteEPC_G2(this.param.ComAddr, WNum, Password, data, Errorcode);
    }

    public int Lock(String EPCStr, byte select, byte setprotect, String PasswordStr) {
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        if (PasswordStr.length() != 8) {
            return 255;
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        byte[] EPC = this.reader.hexStringToBytes(EPCStr);
        byte[] Password = this.reader.hexStringToBytes(PasswordStr);
        byte[] Errorcode = new byte[1];
        return this.reader.Lock_G2(this.param.ComAddr, ENum, EPC, select, setprotect, Password, Errorcode);
    }

    public int Kill(String EPCStr, String PasswordStr) {
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        if (PasswordStr.length() != 8) {
            return 255;
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        byte[] EPC = this.reader.hexStringToBytes(EPCStr);
        byte[] Password = this.reader.hexStringToBytes(PasswordStr);
        byte[] Errorcode = new byte[1];
        return this.reader.Kill_G2(this.param.ComAddr, ENum, EPC, Password, Errorcode);
    }

    public void SetTagCallBack(TagCallback callback) {
        this.reader.SetCallBack(callback);
    }

    public void StartRead(final int mode) {
        if (this.mThread == null) {
            this.mWorking = true;
            this.mThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int Target = 0;
                    while (UHFLib.this.mWorking) {
                        if (mode == 0) {
                            int[] pOUcharTagNum = new int[1];
                            int[] pListLen = new int[]{0};
                            pOUcharTagNum[0] = 0;
                            if (((UHFLib)UHFLib.this).param.Session == 0 || ((UHFLib)UHFLib.this).param.Session == 1) {
                                Target = 0;
                                UHFLib.this.NoCardCOunt = 0;
                            }
                            int result = UHFLib.this.reader.Inventory_G2(((UHFLib)UHFLib.this).param.ComAddr, (byte)((UHFLib)UHFLib.this).param.QValue, (byte)((UHFLib)UHFLib.this).param.Session, (byte)((UHFLib)UHFLib.this).param.TidPtr, (byte)((UHFLib)UHFLib.this).param.TidLen, UHFLib.this.pOUcharIDList, pOUcharTagNum, pListLen);
                            if (pOUcharTagNum[0] == 0) {
                                if (((UHFLib)UHFLib.this).param.Session <= 1) continue;
                                UHFLib uHFLib = UHFLib.this;
                                uHFLib.NoCardCOunt = uHFLib.NoCardCOunt + 1;
                                if (UHFLib.this.NoCardCOunt <= 7) continue;
                                Target = (byte)(1 - Target);
                                UHFLib.this.NoCardCOunt = 0;
                                continue;
                            }
                            UHFLib.this.NoCardCOunt = 0;
                            continue;
                        }
                        UHFLib.this.reader.GetActiveData();
                        if (System.currentTimeMillis() - UHFLib.this.beginTime <= 30000L) continue;
                        byte[] CMD = new byte[2];
                        CMD[1] = 0;
                        CMD[0] = 0;
                        UHFLib.this.reader.SendCMD(CMD);
                        UHFLib.this.beginTime = System.currentTimeMillis();
                    }
                }
            });
            this.mThread.start();
        }
    }

    public void StopRead() {
        if (this.mThread != null) {
            this.mWorking = false;
            this.mThread = null;
        }
    }
}

