/*
 * Decompiled with CFR 0.152.
 */
package com.rfid.trans188;

import com.rfid.serialport.SerialPort;
import com.rfid.trans188.UhfTcpReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;

public class MessageTran {
    private InputStream mInStream = null;
    private OutputStream mOutStream = null;
    private SerialPort mSerialPort = null;
    private boolean connected = false;
    private int mType = 0;
    private UhfTcpReader mtcp = new UhfTcpReader();

    public MessageTran(int mType) {
        this.mType = mType;
    }

    public boolean isOpen() {
        if (this.mType == 0) {
            return this.connected;
        }
        return this.mtcp.connected();
    }

    public int openCom(String ComPort, int BaudRate) {
        try {
            this.mSerialPort = new SerialPort(new File(ComPort), BaudRate, 0);
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
        }
        catch (InvalidParameterException invalidParameterException) {
            // empty catch block
        }
        if (this.mSerialPort != null) {
            this.mInStream = this.mSerialPort.getInputStream();
            this.mOutStream = this.mSerialPort.getOutputStream();
            this.connected = true;
            return 0;
        }
        return -1;
    }

    public int closeCom() {
        if (this.mInStream != null) {
            try {
                this.mInStream.close();
                this.mOutStream.close();
                this.mSerialPort.close();
                this.mSerialPort = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.connected = false;
        return 0;
    }

    public int openTcp(String ip, int port) {
        return this.mtcp.connect(ip, port);
    }

    public int CloseTcp() {
        return this.mtcp.disconnect();
    }

    public byte[] Read() {
        if (this.mType == 0) {
            if (!this.connected) {
                return null;
            }
            try {
                byte[] RecvBuff;
                int len;
                int count = this.mInStream.available();
                if (count > 0 && (len = this.mInStream.read(RecvBuff = new byte[count])) > 0) {
                    byte[] buff = new byte[len];
                    System.arraycopy(RecvBuff, 0, buff, 0, len);
                    return buff;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        if (!this.mtcp.connected()) {
            return null;
        }
        return this.mtcp.read();
    }

    public int Write(byte[] buffer) {
        if (this.mType == 0) {
            if (!this.connected) {
                return -1;
            }
            if (buffer.length != (buffer[0] & 0xFF) + 1) {
                return -1;
            }
            try {
                byte[] cmd = new byte[(buffer[0] & 0xFF) + 1];
                System.arraycopy(buffer, 0, cmd, 0, cmd.length);
                this.mOutStream.write(cmd);
                return 0;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
        if (!this.mtcp.connected()) {
            return -1;
        }
        if (buffer.length != (buffer[0] & 0xFF) + 1) {
            return -1;
        }
        byte[] cmd = new byte[(buffer[0] & 0xFF) + 1];
        System.arraycopy(buffer, 0, cmd, 0, cmd.length);
        return this.mtcp.write(cmd);
    }
}

