#pragma once
#include "time.h"
#include <atlstr.h> 
#include <iostream>
#include <fstream>
#include <assert.h>
#include "stdlib.h"
#include <tchar.h>
#include <windows.h>
#include <setupapi.h>
#include <winsock2.h>
#include <cassert>  
#define __inner_checkReturn
#define PASSIVE_LEVEL 0
#define __drv_maxIRQL(irql)
#define __drv_when(cond, annotes)
#define __drv_freesMem(kind)
using namespace std;
#pragma comment(lib, "ws2_32.lib")   
#define ASSERT assert   


typedef struct _RFIDTag  
{  
	unsigned char PacketParam;//ݰͱ־
	unsigned char LEN;//
	LPCTSTR UID; //EPCUID
	unsigned int phase_begin;
	unsigned int phase_end;
	unsigned char RSSI;
	unsigned char ANT;
	int FrmHandle;  
}MyStruct, *RFIDTagStruct;    

typedef void(CALLBACK *pRFIDCallBack)(RFIDTagStruct lpRfid, INT32 nEvt);

class Reader
{
private:
	union 
	{
		unsigned char data[90];
		struct 
		{
			unsigned char Len;				//ݳ,ֽ
			unsigned char ComAddr;			//дַ0~254,255Ϊ㲥ַ
			unsigned char CMD;				//
			unsigned char Data[87];			//,Len=4ûд
		}comData;
	}sendBuff;
	unsigned char recvBuff[50000];
	unsigned char btArBuff[10000];
	//unsigned char btRecvArr[250000];
	int btRecv;
	int recvLength;
	DCB portDCB;
	HANDLE hCommPort;			//ھ
	DWORD time1;
	DWORD time2;
	DWORD time3;
	unsigned char inventoryScanTime;
	fstream _file;
	BOOL LogFileFlag;
	
	BOOL isInventoryCmd;//Ƿѯ
    SOCKET sServer;
	

	
public:
	Reader(void);
	virtual ~Reader(void);

	BOOL InventoryBackUID;//ѯǷ񷵻UID
	pRFIDCallBack MypCallBack;//
    int FrmHandle;//ⲿľţҪڻصʱλĸ豸˱ǩ
	BOOL DeviceIsOpen;
	CString ipAddress;
	int m_Type;//1-COM2-TCP
	void parserRidTag(unsigned char *btFrm,int cmd);
	int ReadRfidData(unsigned char *Recv);
    void GetCRC(unsigned char *pData, int len);
	int CheckCRC(unsigned char *pData, int len);
    int SendDataToPort(unsigned char *dataToSend, unsigned int BytesOfSend);
	int GetDataFromPort(unsigned char *Recv, int *pLengthOfRecved);
	int AutoGetDataFromPort(unsigned char *Recv, int *pLengthOfRecved,int command);
    int GetQueryDataFromPort(unsigned char *Recv, int *pLengthOfRecved);
	int GetWriteDataFromPort(unsigned char *Recv, int *pLengthOfRecved);
    int Open_Net(int Port,LPCTSTR IPaddr);
	int OpenCom(int portNumber,unsigned char fbaud);
	int OpenByTCP(int Port,LPCTSTR IPaddr,unsigned char*ComAdr);
	int CloseByTCP();
	int OpenByCOM(int port,unsigned char *address,unsigned char baud);
	int CloseByCOM();
	int WriteCard_G2 (unsigned char *address,
		unsigned char *EPC,
		unsigned char Mem,
		unsigned char WordPtr,
		unsigned char Writedatalen,
		unsigned char *Writedata,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		int *WrittenDataNum,
		unsigned char EPClength,
		int *Errorcode);
	int WriteBlock_G2 (unsigned char *address,
		unsigned char *EPC,
		unsigned char Mem,
		unsigned char WordPtr,
		unsigned char Writedatalen,
		unsigned char *Writedata,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		int *WrittenDataNum,
		unsigned char EPClength,
		int *Errorcode);
	int ReadCard_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char Mem,
		unsigned char WordPtr,
		unsigned char Num,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		unsigned char *Data,
		unsigned char EPClength,
		int *Errorcode);
	int Inventory_G2(unsigned char *address,
		unsigned char Qvalue,
		unsigned char Session,
		unsigned char AdrTID,
		unsigned char LenTID,
		unsigned char TIDFlag,
		unsigned char* pOUcharIDList,
		int *Totallen,		
		int *CardNum);
	int GetReaderInfor(unsigned char* ComAdr,				//дַ		
		unsigned char* VersionInfo,			//汾
		unsigned char* ReaderType,				//дͺ
		unsigned char* TrType,		//ֵ֧Э
		unsigned char* dmaxfre,           //ǰдʹõƵ
		unsigned char* dminfre,           //ǰдʹõƵ
		unsigned char* powerdBm,             //д
		unsigned char* ScanTime);
	int SetEASAlarm_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		unsigned char EAS,
		unsigned char EPClength,
		int *Errorcode);
	int CheckEASAlarm_G2(unsigned char *address,int *Eerrorcode);
	int SetCardProtect_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char select,
		unsigned char setprotect,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		unsigned char EPClength,
		int *Errorcode);
	int Writedfre(unsigned char * address,
		unsigned char *dmaxfre,
		unsigned char *dminfre);
	int WriteComAdr(unsigned char *address,
		unsigned char *ComAdrData);
	int WriteScanTime(unsigned char *address,
		unsigned char *ScanTime);
	int Writebaud(unsigned char *address,
		unsigned char *baud);
	int SetPowerDbm(unsigned char *address,
		unsigned char PowerDbm);

	int SetTriggerTime(unsigned char *ComAdr,
		unsigned char *TriggerTime);

	int BuzzerAndLEDControl(unsigned char *address,
		unsigned char AvtiveTime,
		unsigned char SilentTime,
		unsigned char Times);
	int SetAccuracy(unsigned char *ComAdr,
		unsigned char Accuracy);
	int SetOffsetTime(unsigned char *ComAdr,
		unsigned char OffsetTime);
	int SetWGParameter(unsigned char *address,
		unsigned char Wg_mode,
		unsigned char Wg_Data_Inteval,
		unsigned char Wg_Pulse_Width,
		unsigned char Wg_Pulse_Inteval);
	int SetWorkMode(unsigned char *address,
		unsigned char *Parameter);
	int GetWorkModeParameter(unsigned char *address,
		unsigned char *Parameter);
	int EraseCard_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char Mem,
		unsigned char WordPtr,
		unsigned char Num,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		unsigned char EPClength,
		int *Errorcode);
	int WriteEPC_G2(unsigned char *address,						       
		unsigned char *Password,
		unsigned char *WriteEPC,
		unsigned char WriteEPClen,
		int *Errorcode);
	int DestroyCard_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		unsigned char EPClength,
		int *Errorcode);
	int SetReadProtect_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		unsigned char EPClength,
		int *Errorcode);
	int SetMultiReadProtect_G2(unsigned char *address,
		unsigned char *Password,
		int *Errorcode);
	int RemoveReadProtect_G2(unsigned char *address,
		unsigned char *Password,
		int *Errorcode);
	int CheckReadProtected_G2(unsigned char *address,
		unsigned char *readpro,
		int *Errorcode);
	int LockUserBlock_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		unsigned char WrdPointer,
		unsigned char EPClength,
		int *Errorcode);

	int Inventory_6B(unsigned char *address,
		unsigned char* ID_6B);

	int inventory2_6B(unsigned char *address,
		unsigned char Condition,
		unsigned char StartAddress,
		unsigned char mask,
		unsigned char *ConditionContent,
		unsigned char* ID_6B,
		int *Cardnum);

	int ReadCard_6B(unsigned char *address,
		unsigned char* ID_6B,
		unsigned char StartAddress,
		unsigned char Num,
		unsigned char *Data,
		int *errorcode);

	int WriteCard_6B(unsigned char *address,
		unsigned char *ID_6B,
		unsigned char StartAddress,
		unsigned char *Writedata,
		unsigned char Writedatalen,
		unsigned char *writtenbyte,
		int *Errorcode);

	int LockByte_6B(unsigned char *address,
		unsigned char *ID_6B,
		unsigned char StartAddress,
		int *Errorcode);

	int CheckLock_6B(unsigned char *address,
		unsigned char *ID_6B,
		unsigned char StartAddress,
		unsigned char *ReLockState,
		int *Errorcode);
	int ReadActiveModeData(unsigned char * ScanModeData,
		int *ValidDatalength);
	int SetFhssMode(unsigned char *ComAdr,
		unsigned char FhssMode);
	int GetFhssMode(unsigned char *ComAdr,
		unsigned char *FhssMode);

	int SetRelay(unsigned char *ComAdr,
		unsigned char RelayStatus);

	int SetAntenna(unsigned char *ComAdr,
		unsigned char Ant_Mode,
		unsigned char Ant_SWTcnt,
		unsigned char AntInfoEn);

	int SetQvalue(unsigned char *ComAdr,
		unsigned char Qvalue);

	int GetAntenna(unsigned char *ComAdr,
		unsigned char *Ant_No);

	int GetQandAntenna(unsigned char *ComAdr,
		unsigned char *Qvalue,
		unsigned char* Ant_Mode,
		unsigned char* Ant_SWTcnt,
		unsigned char* AntInfoEn);

	int SetPSW(unsigned char *ComAdr,
		unsigned char* PSW);

	int GetPSW(unsigned char *ComAdr,
		unsigned char* PSW);

	int SetUserEPC(unsigned char *ComAdr,
		unsigned char* UserEPC);

	int GetUserEPC(unsigned char *ComAdr,
		unsigned char* UserEPC);
	int ReadData_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char ENum,
		unsigned char Mem,
		unsigned char WordPtr,
		unsigned char Num,
		unsigned char *Password,
		unsigned char MaskMem,
		unsigned char *MaskAdr,
		unsigned char MaskLen,
		unsigned char *MaskData,
		unsigned char *Data,
		int *Errorcode);
	int WriteData_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char WNum,
		unsigned char ENum,
		unsigned char Mem,
		unsigned char WordPtr,
		unsigned char *Wdt,
		unsigned char *Password,
		unsigned char MaskMem,
		unsigned char *MaskAdr,
		unsigned char MaskLen,
		unsigned char *MaskData,
		int *Errorcode);
	int Lock_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char ENum,
		unsigned char select,
		unsigned char setprotect,
		unsigned char *Password,
		unsigned char MaskMem,
		unsigned char *MaskAdr,
		unsigned char MaskLen,
		unsigned char *MaskData,
		int *Errorcode);
	int WriteEPCByMask(unsigned char *address,
		unsigned char *EPC,
		unsigned char WNum,
		unsigned char ENum,
		unsigned char *Password,
		unsigned char *WData,
		unsigned char MaskMem,
		unsigned char *MaskAdr,
		unsigned char MaskLen,
		unsigned char *MaskData,
		int *Errorcode);
	int ExtReadCard_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char Mem,
		unsigned char *WordPtr,
		unsigned char Num,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		unsigned char *Data,
		unsigned char EPClength,
		int *Errorcode);
	int ExtWriteCard_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char Mem,
		unsigned char *WordPtr,
		unsigned char Writedatalen,
		unsigned char *Writedata,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		int *WrittenDataNum,
		unsigned char EPClength,
		int *Errorcode);
	int ExtEraseCard_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char Mem,
		unsigned char *WordPtr,
		unsigned char Num,
		unsigned char *Password,
		unsigned char maskadr,
		unsigned char maskLen,
		unsigned char maskFlag,
		unsigned char EPClength,
		int *Errorcode);


	int ExtReadData_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char ENum,
		unsigned char Mem,
		unsigned char *WordPtr,
		unsigned char Num,
		unsigned char *Password,
		unsigned char MaskMem,
		unsigned char *MaskAdr,
		unsigned char MaskLen,
		unsigned char *MaskData,
		unsigned char *Data,
		int *Errorcode);


	int ExtWriteData_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char WNum,
		unsigned char ENum,
		unsigned char Mem,
		unsigned char *WordPtr,
		unsigned char *Wdt,
		unsigned char *Password,
		unsigned char MaskMem,
		unsigned char *MaskAdr,
		unsigned char MaskLen,
		unsigned char *MaskData,
		int *Errorcode);

	int GetSerialNo(unsigned char *ComAdr,
		unsigned char* SeriaNo);

	int SetSerialNo(unsigned char *ComAdr,
		unsigned char* SeriaNo);

	int GetInputPin(unsigned char *ComAdr,
		unsigned char* InputPin);

	int ReadEEPROM(unsigned char *ComAdr,
		unsigned char Pointer,
		unsigned char Num,
		unsigned char *Data);

	int WriteEEPROM(unsigned char *ComAdr,
		unsigned char Pointer,
		unsigned char Num,
		unsigned char *Data);

	int SetSyris_Data_Inteval(unsigned char *address,
		unsigned char *Syris_Data_Inteval);

	int AdvInventory_G2(unsigned char *address,
		unsigned char AntMode,
		unsigned char* pOUcharIDList,
		int *Totallen,		
		int *CardNum);

	int ExtAdvReadData_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char ENum,
		unsigned char Mem,
		unsigned char *WordPtr,
		unsigned char Num,
		unsigned char *Password,
		unsigned char AntSelect,
		unsigned char *Data,
		int *Errorcode);

	int ExtAdvWriteData_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char WNum,
		unsigned char ENum,
		unsigned char Mem,
		unsigned char *WordPtr,
		unsigned char *Wdt,
		unsigned char *Password,
		unsigned char AntSelect,
		int *Errorcode);

	int ExtAdvWriteBlock_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char WNum,
		unsigned char ENum,
		unsigned char Mem,
		unsigned char *WordPtr,
		unsigned char *Wdt,
		unsigned char *Password,
		unsigned char AntSelect,
		int *Errorcode);

	int ExtAdvEraseBlock_G2(unsigned char *address,
		unsigned char *EPC,
		unsigned char ENum,
		unsigned char Mem,
		unsigned char *WordPtr,
		unsigned char Num,
		unsigned char *Password,
		unsigned char AntSelect,
		unsigned char *Data,
		int *Errorcode);

	int GetQS(unsigned char *address,unsigned char *Qvalue,unsigned char *Session);
	int SetQS(unsigned char *address,unsigned char Qvalue,unsigned char Session);

	int SetCfgParameter(unsigned char *address,unsigned char opt,unsigned char cfgNo,unsigned char *cfgData,int len);
	int GetCfgParameter(unsigned char *address,unsigned char cfgNo,unsigned char *cfgData,int *len);
};
