
/**
 *  CRC16У㷨
 */
public class Crc16Util {

	/**
	 * һֽڰλ 8
	 */
	private static final int BITS_OF_BYTE = 8;
	/**
	 * ʽ
	 */
	private static final int POLYNOMIAL = 0x8408;
	/**
	 * ʼֵ
	 */
	private static final int INITIAL_VALUE = 0xFFFF;

	/**
	 * CRC16 
	 *
	 * @param bytes 
	 * @return 
	 */
	public static int crc16(int[] bytes) {
		int res = INITIAL_VALUE;
		for (int data : bytes) {
			res = res ^ data;
			for (int i = 0; i < BITS_OF_BYTE; i++) {
				res = (res & 0x0001) == 1 ? (res >> 1) ^ POLYNOMIAL : res >> 1;
			}
		}
		return revert(res);
	}

	/**
	 * ת16λĸ߰λ͵Ͱλֽ
	 *
	 * @param src ת
	 * @return ת
	 */
	private static int revert(int src) {
		int lowByte = (src & 0xFF00) >> 8;
		int highByte = (src & 0x00FF) << 8;
		return lowByte | highByte;
	}
	/** ʮתΪIntBytes
	 * @param s ʮƴ
	 * @return  int[] bytes
	 */
	public static int[] hexString2IntBytes(String s) {
		int[] bytes;
		bytes = new int[s.length() / 2];
		for (int i = 0; i < bytes.length; i++) {
			
			bytes[i] = (int) Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
		}
		return bytes;
	}
}
