﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace UHFGateDemo
{
    public partial class ActionForm : Form
    {
        public int ActionType = 0;
        int fCmdRet = 0x30;
        public ActionForm()
        {
            InitializeComponent();
        }

        private string GetReturnCodeDesc(int cmdRet)
        {
            switch (cmdRet)
            {
                case 0x00:
                    return "Success";
                case 0x01:
                    return "Command length error";
                case 0x02:
                    return "Command Not support ";
                case 0x03:
                    return "Parameter range error ";
                case 0x04:
                    return "Command can not doing at this moment ";
                case 0x06:
                    return "FLASH operate error";
                case 0x07:
                    return "Command operate error";
                case 0x31:
                    return "CRC check error";
                case 0x30:
                    return "Communication error";
                case 0x37:
                    return "Invalid handle";
                case 0xEE:
                    return "Command code error";
                default:
                    return "Unknown error";
            }
        }

        private void AddCmdLog(string CMD, string cmdStr, int cmdRet)
        {
            try
            {
                StatusBar1.Panels[0].Text = "";
                StatusBar1.Panels[0].Text = DateTime.Now.ToLongTimeString() + " " +
                                            cmdStr + ": " +
                                            GetReturnCodeDesc(cmdRet);
            }
            finally
            {
                ;
            }
        }

        private void btSetAction_Click(object sender, EventArgs e)
        {
            try
            {
                byte BuzzOpenT, BuzzcloseT, BuzzCnt, BuzzVol, LEDEn, LEDOpenT, LEDCloseT, LEDCnt, Relay1T, Relay2T, BeepT;
                BuzzOpenT = Convert.ToByte(num_bzon.Value.ToString(),10);
                BuzzcloseT = Convert.ToByte(num_bzoff.Value.ToString(), 10);
                BuzzCnt = Convert.ToByte(num_bzcount.Value.ToString(), 10);
                BuzzVol = Convert.ToByte(num_bzvol.Value.ToString(), 10);

                LEDEn = 0;
                //if (com_ch1.SelectedIndex == 1) LEDEn |= 0x01;
                //if (com_ch2.SelectedIndex == 1) LEDEn |= 0x02;
                if (com_ch1.SelectedIndex == 0) LEDEn |= 0x01;
                if (com_ch1.SelectedIndex == 1) LEDEn |= 0x02;
                if (com_ch2.SelectedIndex == 0) LEDEn |= 0x04;
                if (com_ch2.SelectedIndex == 1) LEDEn |= 0x08;

                LEDOpenT = Convert.ToByte(num_ledon.Value.ToString(), 10);
                LEDCloseT = Convert.ToByte(num_ledoff.Value.ToString(), 10);
                LEDCnt = Convert.ToByte(num_ledcount.Value.ToString(), 10);

                Relay1T = Convert.ToByte(num_acrelay1.Value.ToString(), 10);
                Relay2T = Convert.ToByte(num_acrelay2.Value.ToString(), 10);

                BeepT = Convert.ToByte(num_acctlbz.Value.ToString(), 10);

                switch (ActionType)
                {
                    case 0:
                        fCmdRet = MainForm.man.SetAlarmEventAction(BuzzOpenT, BuzzcloseT, BuzzCnt, BuzzVol, LEDEn, LEDOpenT, LEDCloseT, LEDCnt, Relay1T, Relay2T, BeepT);
                        break;
                    case 1:
                        fCmdRet = MainForm.man.SetPersionEnterEventAction(BuzzOpenT, BuzzcloseT, BuzzCnt, BuzzVol, LEDEn, LEDOpenT, LEDCloseT, LEDCnt, Relay1T, Relay2T, BeepT);
                        break;
                    case 2:
                        fCmdRet = MainForm.man.SetPersionLeaveEventAction(BuzzOpenT, BuzzcloseT, BuzzCnt, BuzzVol, LEDEn, LEDOpenT, LEDCloseT, LEDCnt, Relay1T, Relay2T, BeepT);
                        break;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetAlarmEventAction", btSetAction.Text, fCmdRet);
        }

        private void btGetAction_Click(object sender, EventArgs e)
        {
            try
            {
                byte BuzzOpenT = 0, BuzzcloseT = 0, BuzzCnt = 0, BuzzVol = 0, LEDEn = 0, LEDOpenT = 0, LEDCloseT = 0, LEDCnt = 0, Relay1T = 0, Relay2T = 0, BeepT = 0;
                switch (ActionType)
                {
                    case 0:
                        fCmdRet = MainForm.man.GetAlarmEventAction(ref BuzzOpenT, ref BuzzcloseT, ref BuzzCnt, ref BuzzVol, ref LEDEn, ref LEDOpenT, ref LEDCloseT, ref LEDCnt, ref Relay1T, ref Relay2T, ref BeepT);
                        break;
                    case 1:
                        fCmdRet = MainForm.man.GetPersionEnterEventAction(ref BuzzOpenT, ref BuzzcloseT, ref BuzzCnt, ref BuzzVol, ref LEDEn, ref LEDOpenT, ref LEDCloseT, ref LEDCnt, ref Relay1T, ref Relay2T, ref BeepT);
                        break;
                    case 2:
                        fCmdRet = MainForm.man.GetPersionLeaveEventAction(ref BuzzOpenT, ref BuzzcloseT, ref BuzzCnt, ref BuzzVol, ref LEDEn, ref LEDOpenT, ref LEDCloseT, ref LEDCnt, ref Relay1T, ref Relay2T, ref BeepT);
                        break;
                }
                if (fCmdRet == 0)
                {
                    num_bzon.Value = BuzzOpenT;
                    num_bzoff.Value = BuzzcloseT;
                    num_bzcount.Value = BuzzCnt;
                    num_bzvol.Value = BuzzVol;

                    //com_ch1.SelectedIndex = LEDEn & 0x01;
                    //com_ch2.SelectedIndex = (LEDEn >> 1) & 0x01;
                    if ((LEDEn&0x01)==0x01)
                    {
                        com_ch1.SelectedIndex = 0;
                    }
                    else if ((LEDEn & 0x02) == 0x02)
                    {
                        com_ch1.SelectedIndex = 1;
                    }
                    else
                    {
                        com_ch1.SelectedIndex = 2;
                    }

                    if ((LEDEn & 0x04) == 0x04)
                    {
                        com_ch2.SelectedIndex = 0;
                    }
                    else if ((LEDEn & 0x08) == 0x08)
                    {
                        com_ch2.SelectedIndex = 1;
                    }
                    else
                    {
                        com_ch2.SelectedIndex = 2;
                    }

                    num_ledon.Value = LEDOpenT;
                    num_ledoff.Value = LEDCloseT;
                    num_ledcount.Value = LEDCnt;

                    num_acrelay1.Value = Relay1T;
                    num_acrelay2.Value = Relay2T;

                    num_acctlbz.Value = BeepT;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetAlarmEventAction", btGetAction.Text, fCmdRet);
        }

        private void ActionForm_Load(object sender, EventArgs e)
        {
            btGetAction_Click(null,null);
        }
    }
}
