﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace UHFGateDemo
{
    public partial class BinaryForm : Form
    {
        public byte[] btMaskEn;
        public byte[] btAlarm;
        public BinaryForm()
        {
            InitializeComponent();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }

        private byte[] BinaryToBytes(string binStr)
        {
            try
            {
                binStr = binStr.Replace(" ", "");
                int len = binStr.Length;
                int bmode = len % 8;
                if (bmode != 0)
                {
                    for (int m = 0; m < (8 - bmode); m++)
                    {
                        binStr += "0";
                    }
                }
                byte[] data = new byte[binStr.Length / 8];
                for (int i = 0; i < data.Length; i++)
                {
                    string bstr = binStr.Substring(i * 8, 8);
                    data[i] = Convert.ToByte(bstr, 2);
                }
                return data;
            }
            catch (System.Exception ex)
            {
                ex.ToString();
                return null;
            }
        }
        private void button1_Click(object sender, EventArgs e)
        {
            if ((textMaskEn.Text.Trim().Length == 0) || (txtAlarmBit.Text.Trim().Length==0))
            {
                return;
            }

            btMaskEn = BinaryToBytes(textMaskEn.Text);
            btAlarm = BinaryToBytes(txtAlarmBit.Text);
            this.DialogResult = DialogResult.OK;
        }

        private void textMaskEn_SelectionChanged(object sender, EventArgs e)
        {
            string temp = textMaskEn.Text.Substring(0, textMaskEn.SelectionStart);
            temp = temp.Replace(" ", "");
            lbCount1.Text = Convert.ToString(temp.Length);
        }

        private void txtAlarmBit_SelectionChanged(object sender, EventArgs e)
        {
            string temp = txtAlarmBit.Text.Substring(0, txtAlarmBit.SelectionStart);
            temp = temp.Replace(" ", "");
            lbCount2.Text = Convert.ToString(temp.Length);
        }

        private void textMaskEn_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("01 ".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }
    }
}
