﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Gate;

namespace UHFGateDemo
{
    public partial class ConfigForm : Form
    {
        int fCmdRet = 0x30;
        public DataGridView gbView1;
        public ConfigForm()
        {
            InitializeComponent();
        }

        #region  16进制字符串到数组之间的相互转换
        private byte[] HexStringToByteArray(string s)
        {
            s = s.Replace(" ", "");
            if ((s.Length % 2) != 0)
                s += "0";
            byte[] buffer = new byte[s.Length / 2];
            for (int i = 0; i < s.Length; i += 2)
                buffer[i / 2] = (byte)Convert.ToByte(s.Substring(i, 2), 16);
            return buffer;
        }
        private string ByteArrayToHexString(byte[] data)
        {
            StringBuilder sb = new StringBuilder(data.Length * 3);
            foreach (byte b in data)
                sb.Append(Convert.ToString(b, 16).PadLeft(2, '0').PadRight(3, ' '));
            return sb.ToString().ToUpper();
        }
        #endregion


        private string GetReturnCodeDesc(int cmdRet)
        {
            switch (cmdRet)
            {
                case 0x00:
                    return "Success";
                case 0x01:
                    return "Command length error";
                case 0x02:
                    return "Command Not support ";
                case 0x03:
                    return "Parameter range error ";
                case 0x04:
                    return "Command can not doing at this moment ";
                case 0x06:
                    return "FLASH operate error";
                case 0x07:
                    return "Command operate error";
                case 0x31:
                    return "CRC check error";
                case 0x30:
                    return "Communication error";
                case 0x37:
                    return "Invalid handle";
                case 0xEE:
                    return "Command code error";
                default:
                    return "Unknown error";
            }
        }

        private void AddCmdLog(string CMD, string cmdStr, int cmdRet)
        {
            try
            {
                StatusBar1.Panels[0].Text = "";
                StatusBar1.Panels[0].Text = DateTime.Now.ToLongTimeString() + " " +
                                            cmdStr + ": " +
                                            GetReturnCodeDesc(cmdRet);
            }
            finally
            {
                ;
            }
        }


        private void SetControAddr_Click(object sender, EventArgs e)
        {
            byte ConAddr = 0;
            if (TextNewConAddr.Text.Length == 0) return;
            try
            {
                ConAddr = Convert.ToByte(TextNewConAddr.Text, 16);
                fCmdRet = MainForm.man.SetControllAddr(ConAddr);
                if(fCmdRet==0)
                {
                    MainForm.man.ComAddr = ConAddr;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetControllAddr", SetControAddr.Text, fCmdRet);
        }

        private void ControAddr_Click(object sender, EventArgs e)
        {
            byte ConAddr = 0;
            try
            {
                TextCulConAddr.Text = "";
                fCmdRet = MainForm.man.GetControllAddr(ref ConAddr);
                if(fCmdRet==0)
                {
                    TextCulConAddr.Text = Convert.ToString(ConAddr,16).PadLeft(2,'0');
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetControllAddr", ControAddr.Text, fCmdRet);
        }

        private void bt_ModeSet_Click(object sender, EventArgs e)
        {
            byte WorkMode = (byte)com_mode.SelectedIndex;
            try
            {
                fCmdRet = MainForm.man.SetWorkMode(WorkMode);
                if(fCmdRet==0)
                {
                    btClearControl_Click(null,null);
                    if (WorkMode==0)
                    {
                        gbView1.Columns[0].HeaderText = "No.";
                        gbView1.Columns[1].HeaderText = "EPC/TID";
                        gbView1.Columns[2].HeaderText = "Count";
                        gbView1.Columns[3].HeaderText = "RSSI";
                    }
                    else
                    {
                        

                        gbView1.Columns[0].HeaderText = "No.";
                        gbView1.Columns[1].HeaderText = "EPC/TID";
                        gbView1.Columns[2].HeaderText = "Alarm Status";
                        gbView1.Columns[3].HeaderText = "";
                    }
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetWorkMode", bt_ModeSet.Text, fCmdRet);
        }

        private void bt_ModeGet_Click(object sender, EventArgs e)
        {
            byte WorkMode = 0;
            try
            {
                fCmdRet = MainForm.man.GetWorkMode(ref WorkMode);
                if (fCmdRet == 0)
                {
                    com_mode.SelectedIndex = WorkMode;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetWorkMode", bt_ModeGet.Text, fCmdRet);
        }

        private void btSetIR_Click(object sender, EventArgs e)
        {
            byte IrDirect = 0;
            try
            {
                if (rb_r.Checked)
                    IrDirect = 0;
                else
                    IrDirect = 1;
                fCmdRet = MainForm.man.SetDirection(IrDirect);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetDirection", btSetIR.Text, fCmdRet);
        }

        private void btGetIR_Click(object sender, EventArgs e)
        {
            byte IrDirect = 0;
            try
            {
                fCmdRet = MainForm.man.GetDirection(ref IrDirect);
                if (fCmdRet == 0)
                {
                    if (IrDirect == 0)
                        rb_r.Checked = true;
                    else
                        rb_L.Checked = true;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetDirection", btGetIR.Text, fCmdRet);
        }

        private void btSetmsgEn_Click(object sender, EventArgs e)
        {
            byte PersionEn =0;
            byte IREn=0;
            byte NoALarmEn = 0;
            try
            {
                if (chk_persion.Checked) PersionEn = 1;
                if (chk_ir.Checked) IREn = 1;
                if (chk_noalarm.Checked) NoALarmEn = 1;
                fCmdRet = MainForm.man.SetMsgEn(PersionEn, IREn, NoALarmEn);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetMsgEn", btSetmsgEn.Text, fCmdRet);
        }

        private void btGetmsgEn_Click(object sender, EventArgs e)
        {
            byte PersionEn = 0;
            byte IREn = 0;
            byte NoALarmEn = 0;
            try
            {
                fCmdRet = MainForm.man.GetMsgEn(ref PersionEn,ref IREn,ref NoALarmEn);
                if (fCmdRet==0)
                {
                    if(PersionEn==1)chk_persion.Checked =true;
                    else chk_persion.Checked = false;

                    if (IREn == 1) chk_ir.Checked = true;
                    else chk_ir.Checked = false;

                    if (NoALarmEn == 1) chk_noalarm.Checked = true;
                    else chk_noalarm.Checked = false;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetMsgEn", btGetmsgEn.Text, fCmdRet);
        }

        private void btSetmsgTranType_Click(object sender, EventArgs e)
        {
            byte MsgAutoUpload = 0;
            byte MsgAck = 0;
            try
            {
                if (rb_auto.Checked) MsgAutoUpload = 1;
                if (chk_ack.Checked) MsgAck = 1;
                fCmdRet = MainForm.man.SetMsgTran(MsgAutoUpload, MsgAck);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetMsgTran", btSetmsgTranType.Text, fCmdRet);
        }

        private void btGetmsgTranType_Click(object sender, EventArgs e)
        {
            byte MsgAutoUpload = 0;
            byte MsgAck = 0;
            try
            {
                fCmdRet = MainForm.man.GetMsgTran(ref MsgAutoUpload,ref MsgAck);
                if(fCmdRet==0)
                {
                    if (MsgAutoUpload == 1)
                        rb_auto.Checked = true;
                    else
                        rb_cmd.Checked = true;

                    if (MsgAck == 1)
                        chk_ack.Checked = true;
                    else
                        chk_ack.Checked = false;

                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetMsgTran", btGetmsgTranType.Text, fCmdRet);
        }

        private void btClearControl_Click(object sender, EventArgs e)
        {
            fCmdRet = Device.ClearBuffer(MainForm.man.ComAddr, MainForm.man.FrmHandle);
            AddCmdLog("ClearBuffer", btClearControl.Text, fCmdRet);

        }

        private void button12_Click(object sender, EventArgs e)
        {
            byte ConnectStatus=0;
            txt_reader1.Text = "";
            txt_reader2.Text = "";
            fCmdRet = Device.GetControllerReaderConnectionStatus(MainForm.man.ComAddr, ref ConnectStatus, MainForm.man.FrmHandle);
            if (fCmdRet==0)
            {
                if ((ConnectStatus & 0x0F)==0x01)
                {
                    txt_reader1.Text = "Normal";
                }
                else
                {
                    txt_reader1.Text = "Abnormal";
                }

                if ((ConnectStatus>>4) == 0x01)
                {
                    txt_reader2.Text = "Normal";
                }
                else
                {
                    txt_reader2.Text = "Abnormal";
                }
            }
        }

        private void btSetGPIO_Click(object sender, EventArgs e)
        {
            byte gpostatus=0;
            if (chk_gpo1.Checked) gpostatus |= 0x01;
            if (chk_gpo2.Checked) gpostatus |= 0x02;
            if (chk_gpo3.Checked) gpostatus |= 0x04;
            if (chk_gpo4.Checked) gpostatus |= 0x08;
            try
            {
                fCmdRet = Device.SetGPIO(MainForm.man.ComAddr, gpostatus, MainForm.man.FrmHandle);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetGPIO", btSetGPIO.Text, fCmdRet);
        }

        private void btGetGPIO_Click(object sender, EventArgs e)
        {
            byte gpistatus = 0;
            try
            {
                fCmdRet = Device.GetGPIO(MainForm.man.ComAddr, ref gpistatus, MainForm.man.FrmHandle);
                if (fCmdRet == 0)
                {
                    if ((gpistatus & 0x01) == 0x01)
                        chk_gp11.Checked = true;
                    else
                        chk_gp11.Checked = false;

                    if ((gpistatus & 0x02) == 0x02)
                        chk_gp12.Checked = true;
                    else
                        chk_gp12.Checked = false;

                    if ((gpistatus & 0x04) == 0x04)
                        chk_gp13.Checked = true;
                    else
                        chk_gp13.Checked = false;

                    if ((gpistatus & 0x08) == 0x08)
                        chk_gp14.Checked = true;
                    else
                        chk_gp14.Checked = false;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetGPIO", btGetGPIO.Text, fCmdRet);
        }

        private void btSetPersonAlarm_Click(object sender, EventArgs e)
        {
            if ((txtOnline.Text.Length == 0) || (txtIncount.Text.Length == 0) || (txtOutcount.Text.Length == 0) || (txtAlarmcount.Text.Length==0))
            {
                return;
            }
            try
            {
                ulong online = Convert.ToUInt64(txtOnline.Text, 10);
                ulong inCount = Convert.ToUInt64(txtIncount.Text, 10);
                ulong outCount = Convert.ToUInt64(txtOutcount.Text, 10);
                ulong AlarmCOunt = Convert.ToUInt64(txtAlarmcount.Text, 10);
                byte[] btonline = new byte[4];
                byte[] btinCount = new byte[4];
                byte[] btoutCount = new byte[4];
                byte[] btAlarmCOunt = new byte[4];
                btonline[0] = (byte)(online >> 24);
                btonline[1] = (byte)((online >> 16) & 0x000000FF);
                btonline[2] = (byte)((online >> 8) & 0x000000FF);
                btonline[3] = (byte)(online & 0x000000FF);

                btinCount[0] = (byte)(inCount >> 24);
                btinCount[1] = (byte)((inCount >> 16) & 0x000000FF);
                btinCount[2] = (byte)((inCount >> 8) & 0x000000FF);
                btinCount[3] = (byte)(inCount & 0x000000FF);

                btoutCount[0] = (byte)(outCount >> 24);
                btoutCount[1] = (byte)((outCount >> 16) & 0x000000FF);
                btoutCount[2] = (byte)((outCount >> 8) & 0x000000FF);
                btoutCount[3] = (byte)(outCount & 0x000000FF);

                btAlarmCOunt[0] = (byte)(AlarmCOunt >> 24);
                btAlarmCOunt[1] = (byte)((AlarmCOunt >> 16) & 0x000000FF);
                btAlarmCOunt[2] = (byte)((AlarmCOunt >> 8) & 0x000000FF);
                btAlarmCOunt[3] = (byte)(AlarmCOunt & 0x000000FF);
                fCmdRet = Device.SetPersionAndAlarmInfo(MainForm.man.ComAddr, btinCount, btoutCount, btonline, btAlarmCOunt, MainForm.man.FrmHandle);

            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetPersionAndAlarmInfo", btSetPersonAlarm.Text, fCmdRet);
        }

        private void TextNewConAddr_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void btGetPersonAlarm_Click(object sender, EventArgs e)
        {
            try
            {
                byte[] btonline = new byte[4];
                byte[] btinCount = new byte[4];
                byte[] btoutCount = new byte[4];
                byte[] btAlarmCOunt = new byte[4];
                txtOnline.Text = "";
                txtIncount.Text = "";
                txtOutcount.Text = "";
                txtAlarmcount.Text = "";
                fCmdRet = Device.GetPersionAndAlarmInfo(MainForm.man.ComAddr, btinCount, btoutCount, btonline, btAlarmCOunt, MainForm.man.FrmHandle);
                if(fCmdRet==0)
                {
                    txtOnline.Text = Convert.ToString((btonline[0] << 24) + (btonline[1] << 16) + (btonline[2] << 8) + btonline[3],10);
                    txtIncount.Text = Convert.ToString((btinCount[0] << 24) + (btinCount[1] << 16) + (btinCount[2] << 8) + btinCount[3], 10);
                    txtOutcount.Text = Convert.ToString((btoutCount[0] << 24) + (btoutCount[1] << 16) + (btoutCount[2] << 8) + btoutCount[3], 10);
                    txtAlarmcount.Text = Convert.ToString((btAlarmCOunt[0] << 24) + (btAlarmCOunt[1] << 16) + (btAlarmCOunt[2] << 8) + btAlarmCOunt[3], 10);
                }

            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetPersionAndAlarmInfo", btGetPersonAlarm.Text, fCmdRet);
        }

        private void ClockCMD_Click(object sender, EventArgs e)
        {

            if ((Text_year.Text.Length == 0) || (Text_month.Text.Length == 0) || (Text_day.Text.Length == 0) ||
               (Text_hour.Text.Length == 0) || (Text_min.Text.Length == 0) || (Text_sec.Text.Length == 0))
            {
                return;
            }

            byte[] Clocktime = new byte[6];
            Clocktime[0] = Convert.ToByte(Text_year.Text, 10);
            Clocktime[1] = Convert.ToByte(Text_month.Text, 10);
            Clocktime[2] = Convert.ToByte(Text_day.Text, 10);
            Clocktime[3] = Convert.ToByte(Text_hour.Text, 10);
            Clocktime[4] = Convert.ToByte(Text_min.Text, 10);
            Clocktime[5] = Convert.ToByte(Text_sec.Text, 10);
            fCmdRet = Device.SetClock(MainForm.man.ComAddr, Clocktime, MainForm.man.FrmHandle);
            AddCmdLog("SetClock", btSetCLock.Text, fCmdRet);

        }



        private void ConfigForm_Load(object sender, EventArgs e)
        {
            try
            {
                cbb_relayNum.SelectedIndex = 0;
                cbb_relayAction.SelectedIndex = 1;
                cbb_ch1.SelectedIndex = 1;
                cbb_ch2.SelectedIndex = 1;

                com_qvalue.SelectedIndex = 4;
                com_session.SelectedIndex = 0;
                radioButton_band2.Checked = true;
                com_contype.SelectedIndex = 0;
                cbb_Reconnect.SelectedIndex = 0;

                com_mode.SelectedIndex = MainForm.man.WorkMode;
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
        }

        private void btSetEAS_Click(object sender, EventArgs e)
        {
            byte AlarmMode = 0;
            byte AlarmType = 0;
            byte[] MaskEn = new byte[62];
            byte[] MaskData =new byte[62]; 
            byte MinLen=0;
            byte MaxLen=0;
            try
            {
                if((txtMaxlen.Text.Length==0)||(txtMinlen.Text.Length==0)||(textMaskEn.Text.Replace(" ","").Length==0)||(txtAlarmBit.Text.Replace(" ","").Length==0))
                {
                    return;
                }
                if (radioButton_EAS.Checked)
                    AlarmMode = 0;
                else
                    AlarmMode = 1;

                if (rb_sh.Checked)
                    AlarmType = 0;
                else if (rb_ct.Checked)
                    AlarmType = 1;
                else if (rb_open.Checked)
                    AlarmType = 2;
                else
                    AlarmType = 3;

                MinLen = Convert.ToByte(txtMinlen.Text, 10);
                MaxLen = Convert.ToByte(txtMaxlen.Text, 10);

                byte[] data = HexStringToByteArray(textMaskEn.Text);
                Array.Copy(data, 0, MaskEn, 0, data.Length);

                data = HexStringToByteArray(txtAlarmBit.Text);
                Array.Copy(data, 0, MaskData, 0, data.Length);
                fCmdRet = MainForm.man.SetAlarmType(AlarmMode, AlarmType);
                fCmdRet = MainForm.man.SetCustomAlarmRules(MaskEn,MaskData,MinLen,MaxLen);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetCustomAlarmRules", btSetEAS.Text, fCmdRet);
        }

        private void btGetEAS_Click(object sender, EventArgs e)
        {
            byte AlarmMode = 0;
            byte AlarmType = 0;
            byte[] MaskEn = new byte[62];
            byte[] MaskData = new byte[62];
            byte MinLen = 0;
            byte MaxLen = 0;
            try
            {
                txtMaxlen.Text = "";
                txtMinlen.Text = "";
                textMaskEn.Text = "";
                txtAlarmBit.Text = "";
                fCmdRet = MainForm.man.GetAlarmType(ref AlarmMode,ref AlarmType);
                if (fCmdRet==0)
                {
                    if (AlarmMode == 0)
                        radioButton_EAS.Checked = true;
                    else
                        radioButton_AFI.Checked = true;

                    if (AlarmType == 0)
                        rb_sh.Checked = true;
                    else if (AlarmType == 1)
                        rb_ct.Checked = true;
                    else if (AlarmType == 2)
                        rb_open.Checked = true;
                    else
                        rb_custom.Checked = true;

                }
                fCmdRet = MainForm.man.GetCustomAlarmRules(MaskEn, MaskData,ref MinLen,ref MaxLen);
                if (fCmdRet == 0)
                {
                    txtMaxlen.Text = Convert.ToString(MaxLen);
                    txtMinlen.Text = Convert.ToString(MinLen);
                    textMaskEn.Text = ByteArrayToHexString(MaskEn);
                    txtAlarmBit.Text = ByteArrayToHexString(MaskData);
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetCustomAlarmRules", btGetEAS.Text, fCmdRet);
        }

        private void button1_Click(object sender, EventArgs e)
        {
             BinaryForm con = new BinaryForm();
             DialogResult result = con.ShowDialog();
             if (result == DialogResult.OK)
             {
                 textMaskEn.Text = ByteArrayToHexString(con.btMaskEn);
                 txtAlarmBit.Text = ByteArrayToHexString(con.btAlarm);
             }
        }

        private void btSetRelay_Click(object sender, EventArgs e)
        {
            try
            {
                byte num=0;
                byte status=0;
                byte time=0;
                num = (byte)cbb_relayNum.SelectedIndex;
                status = (byte)cbb_relayAction.SelectedIndex;
                time = Convert.ToByte(nums_relay.Value.ToString(), 10);
                fCmdRet = Device.SetRelay(MainForm.man.ComAddr, num, status, time, MainForm.man.FrmHandle);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetRelay", btSetRelay.Text, fCmdRet);
        }

        private void btBeepAndLed_Click(object sender, EventArgs e)
        {
            try
            {
                 byte bzonTime =0;
                 byte bzoffTime=0;
                 byte bzCount=0;
                 byte vol = 0;
                 byte ledonTime = 0;
                 byte ledoffTime = 0;
                 byte ledCount = 0;
                 byte nColor = 0;
                 bzonTime = Convert.ToByte(nums_bzon.Value.ToString(), 10);
                 bzoffTime = Convert.ToByte(nums_bzoff.Value.ToString(), 10);
                 bzCount = Convert.ToByte(nums_bzcount.Value.ToString(), 10);
                 vol = Convert.ToByte(nums_bzvol.Value.ToString(), 10);

                 ledonTime = Convert.ToByte(nums_ledon.Value.ToString(), 10);
                 ledoffTime = Convert.ToByte(nums_ledoff.Value.ToString(), 10);
                 ledCount = Convert.ToByte(nums_ledcount.Value.ToString(), 10);

                 if (cbb_ch1.SelectedIndex == 0) nColor |= 0x01;
                 if (cbb_ch1.SelectedIndex == 1) nColor |= 0x02;
                 if (cbb_ch2.SelectedIndex == 0) nColor |= 0x04;
                 if (cbb_ch2.SelectedIndex == 1) nColor |= 0x08;
                 fCmdRet = Device.SetBuzzer(MainForm.man.ComAddr, bzonTime, bzoffTime, bzCount, vol, MainForm.man.FrmHandle);
                 fCmdRet = Device.SetLED(MainForm.man.ComAddr, ledonTime, ledoffTime, ledCount, nColor, MainForm.man.FrmHandle);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetLED", btBeepAndLed.Text, fCmdRet);
        }

        private void textMaskEn_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF ".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void btSetIvtType_Click(object sender, EventArgs e)
        {
            try
            {
                byte InventoryType = 0;
                if (rb_epc.Checked)
                    InventoryType = 0;
                else
                    InventoryType = 1;
                fCmdRet = MainForm.man.SetInventoryType(InventoryType);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetInventoryType", btSetIvtType.Text, fCmdRet);
        }

        private void btGetIvtType_Click(object sender, EventArgs e)
        {
            try
            {
                byte InventoryType = 0;
                fCmdRet = MainForm.man.GetInventoryType(ref InventoryType);
                if(fCmdRet==0)
                {
                    if (InventoryType == 0)
                        rb_epc.Checked = true;
                    else
                        rb_tid.Checked = true;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetInventoryType", btGetIvtType.Text, fCmdRet);
        }

        private void btSetIvtParam_Click(object sender, EventArgs e)
        {
            try
            {
                byte qvalue = (byte)com_qvalue.SelectedIndex;
                byte session = (byte)com_session.SelectedIndex;
                fCmdRet = MainForm.man.SetInventoryParam(qvalue, session);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetInventoryParam", btSetIvtParam.Text, fCmdRet);
        }

        private void btGetIvtParam_Click(object sender, EventArgs e)
        {
            try
            {
                byte qvalue = 0;
                byte session = 0;
                fCmdRet = MainForm.man.GetInventoryParam(ref qvalue,ref session);
                if(fCmdRet==0)
                {
                    com_qvalue.SelectedIndex = qvalue;
                    com_session.SelectedIndex = session;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetInventoryParam", btGetIvtParam.Text, fCmdRet);
        }

        private void btSetTidParam_Click(object sender, EventArgs e)
        {
            if((txtTidAddr.Text=="")||(txtTidLen.Text==""))
                return;
            try
            {
                byte FirstAddr=0;
                byte Length = 0;
                FirstAddr = Convert.ToByte(txtTidAddr.Text, 10);
                Length = Convert.ToByte(txtTidLen.Text, 10);
                fCmdRet = MainForm.man.SetTIDParam(FirstAddr, Length);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetTIDParam", btSetTidParam.Text, fCmdRet);
        }

        private void btGetTidParam_Click(object sender, EventArgs e)
        {
            txtTidAddr.Text ="";
            txtTidLen.Text = "";
            try
            {
                byte FirstAddr = 0;
                byte Length = 0;
                fCmdRet = MainForm.man.GetTIDParam(ref FirstAddr,ref Length);
                if(fCmdRet==0)
                {
                    txtTidAddr.Text = FirstAddr.ToString();
                    txtTidLen.Text = Length.ToString();
                }

            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetTIDParam", btGetTidParam.Text, fCmdRet);
        }

        private void btSetFilterTime_Click(object sender, EventArgs e)
        {
            try
            {
                byte FliterTime = (byte)num_filterTime.Value;
                fCmdRet = MainForm.man.SetFilterTime(FliterTime);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetFilterTime", btSetFilterTime.Text, fCmdRet);
        }

        private void btGetFilterTime_Click(object sender, EventArgs e)
        {
            try
            {
                byte FliterTime =0;
                fCmdRet = MainForm.man.GetFilterTime(ref FliterTime);
                if(fCmdRet==0)
                {
                    num_filterTime.Value = FliterTime;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetFilterTime", btGetFilterTime.Text, fCmdRet);
        }

        private void btSetMask_Click(object sender, EventArgs e)
        {
            try
            {
                if ((txt_Maddr.Text == "") || (txt_Mlen.Text == "") || (txt_Mdata.Text.Replace(" ","")==""))
                {
                    return;
                }
                byte MaskEn=0; 
                byte MaskMem=0;
                byte[] MaskAddr=new byte[2];
                byte MaskLen=0;
                byte[] MaskData=new byte[32];
                if (chk_masken.Checked)
                    MaskEn = 1;

                if (RBM_EPC.Checked)
                    MaskMem = 1;
                else if(RBM_TID.Checked)
                    MaskMem = 2;
                else
                    MaskMem = 3;

                int StartAddr = Convert.ToInt32(txt_Maddr.Text, 10);
                MaskAddr[0] = (byte)(StartAddr >> 8);
                MaskAddr[1] = (byte)(StartAddr & 0x00FF);
                MaskLen = Convert.ToByte(txt_Mlen.Text, 10);

                byte[] data = HexStringToByteArray(txt_Mdata.Text.Replace(" ", ""));
                if(data.Length>32)
                {
                    Array.Copy(data, 0, MaskData, 0, 32);
                }
                else
                {
                    Array.Copy(data, 0, MaskData, 0, data.Length);
                }
                fCmdRet = MainForm.man.SetMaskParam(MaskEn, MaskMem, MaskAddr, MaskLen, MaskData);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetMaskParam", btSetMask.Text, fCmdRet);
        }

        private void btGetMask_Click(object sender, EventArgs e)
        {
            try
            {
                txt_Maddr.Text = "";
                txt_Mlen.Text = "";
                txt_Mdata.Text = "";
                byte MaskEn = 0;
                byte MaskMem = 0;
                byte[] MaskAddr = new byte[2];
                byte MaskLen = 0;
                byte[] MaskData = new byte[32];
                fCmdRet = MainForm.man.GetMaskParam(ref MaskEn,ref MaskMem, MaskAddr,ref MaskLen, MaskData);
                if (fCmdRet==0)
                {
                    if (MaskEn == 1)
                        chk_masken.Checked = true;
                    else
                        chk_masken.Checked = false;

                    if (MaskMem == 1)
                        RBM_EPC.Checked = true;
                    else if (MaskMem == 2)
                        RBM_TID.Checked = true;
                    else if (MaskMem == 3)
                        RBM_USER.Checked = true;

                    txt_Maddr.Text = Convert.ToString(MaskAddr[0] * 256 + MaskAddr[1],10);
                    txt_Mlen.Text = Convert.ToString(MaskLen, 10);
                    txt_Mdata.Text = ByteArrayToHexString(MaskData);
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetMaskParam", btGetMask.Text, fCmdRet);
        }

        private void groupBox26_Enter(object sender, EventArgs e)
        {

        }

        private void radioButton_band1_CheckedChanged(object sender, EventArgs e)
        {
            int i;
            ComboBox_dmaxfre.Items.Clear();
            ComboBox_dminfre.Items.Clear();
            for (i = 0; i < 20; i++)
            {
                ComboBox_dminfre.Items.Add(Convert.ToString(920.125 + i * 0.25) + " MHz");
                ComboBox_dmaxfre.Items.Add(Convert.ToString(920.125 + i * 0.25) + " MHz");
            }
            ComboBox_dmaxfre.SelectedIndex = 19;
            ComboBox_dminfre.SelectedIndex = 0;
        }

        private void radioButton_band2_CheckedChanged(object sender, EventArgs e)
        {
            int i;
            ComboBox_dmaxfre.Items.Clear();
            ComboBox_dminfre.Items.Clear();
            for (i = 0; i < 50; i++)
            {
                ComboBox_dminfre.Items.Add(Convert.ToString(902.75 + i * 0.5) + " MHz");
                ComboBox_dmaxfre.Items.Add(Convert.ToString(902.75 + i * 0.5) + " MHz");
            }
            ComboBox_dmaxfre.SelectedIndex = 49;
            ComboBox_dminfre.SelectedIndex = 0;
        }

        private void radioButton_band3_CheckedChanged(object sender, EventArgs e)
        {
            int i;
            ComboBox_dmaxfre.Items.Clear();
            ComboBox_dminfre.Items.Clear();
            for (i = 0; i < 32; i++)
            {
                ComboBox_dminfre.Items.Add(Convert.ToString(917.1 + i * 0.2) + " MHz");
                ComboBox_dmaxfre.Items.Add(Convert.ToString(917.1 + i * 0.2) + " MHz");
            }
            ComboBox_dmaxfre.SelectedIndex = 31;
            ComboBox_dminfre.SelectedIndex = 0;
        }

        private void radioButton_band4_CheckedChanged(object sender, EventArgs e)
        {
            int i;
            ComboBox_dmaxfre.Items.Clear();
            ComboBox_dminfre.Items.Clear();
            for (i = 0; i < 15; i++)
            {
                ComboBox_dminfre.Items.Add(Convert.ToString(865.1 + i * 0.2) + " MHz");
                ComboBox_dmaxfre.Items.Add(Convert.ToString(865.1 + i * 0.2) + " MHz");
            }
            ComboBox_dmaxfre.SelectedIndex = 14;
            ComboBox_dminfre.SelectedIndex = 0;
        }

        private void btSetWork_Click(object sender, EventArgs e)
        {
            try
            {
                byte FreqBand = 0;
                byte MaxFre = 0;
                byte MinFre = 0;
                if (radioButton_band1.Checked)
                    FreqBand = 1;
                if (radioButton_band2.Checked)
                    FreqBand = 2;
                if (radioButton_band3.Checked)
                    FreqBand = 3;
                if (radioButton_band4.Checked)
                    FreqBand = 4;
                MaxFre = (byte)ComboBox_dmaxfre.SelectedIndex;
                MinFre = (byte)ComboBox_dminfre.SelectedIndex;
                fCmdRet = MainForm.man.SetRegion(FreqBand, MaxFre, MinFre);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetRegion", btSetWork.Text, fCmdRet);
        }

        private void btGetWork_Click(object sender, EventArgs e)
        {
            try
            {
                byte FreqBand = 0;
                byte MaxFre = 0;
                byte MinFre = 0;
                fCmdRet = MainForm.man.GetRegion(ref FreqBand,ref MaxFre,ref MinFre);
                if (fCmdRet==0)
                {
                    if (FreqBand == 1)
                        radioButton_band1.Checked = true;
                    else if (FreqBand==2)
                        radioButton_band2.Checked = true;
                    else if (FreqBand == 3)
                        radioButton_band3.Checked = true;
                    else if (FreqBand == 4)
                        radioButton_band4.Checked = true;

                    ComboBox_dmaxfre.SelectedIndex = MaxFre;
                    ComboBox_dminfre.SelectedIndex = MinFre;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetRegion", btGetWork.Text, fCmdRet);
        }

        private void btSetPower_Click(object sender, EventArgs e)
        {
            if ((txtPower1.Text == "") || (txtPower2.Text == "") || (txtPower3.Text == "") || (txtPower4.Text == "")
                || (txtPower5.Text == "") || (txtPower6.Text == "") || (txtPower7.Text == "") || (txtPower8.Text == ""))
            {
                return;
            }
            try
            {
                byte[]Power =new byte[8];
                Power[0] = Convert.ToByte(txtPower1.Text, 10);
                Power[1] = Convert.ToByte(txtPower2.Text, 10);
                Power[2] = Convert.ToByte(txtPower3.Text, 10);
                Power[3] = Convert.ToByte(txtPower4.Text, 10);
                Power[4] = Convert.ToByte(txtPower5.Text, 10);
                Power[5] = Convert.ToByte(txtPower6.Text, 10);
                Power[6] = Convert.ToByte(txtPower7.Text, 10);
                Power[7] = Convert.ToByte(txtPower8.Text, 10);
                fCmdRet = MainForm.man.SetReaderPower(Power);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetReaderPower", btSetPower.Text, fCmdRet);
        }

        private void btGetPower_Click(object sender, EventArgs e)
        {
            try
            {
                byte[] Power = new byte[8];
                txtPower1.Text = "";
                txtPower2.Text = "";
                txtPower3.Text = "";
                txtPower4.Text = "";
                txtPower5.Text = "";
                txtPower6.Text = "";
                txtPower7.Text = "";
                txtPower8.Text = "";
                fCmdRet = MainForm.man.GetReaderPower(Power);
                if(fCmdRet==0)
                {
                    txtPower1.Text = Convert.ToString(Power[0]);
                    txtPower2.Text = Convert.ToString(Power[1]);
                    txtPower3.Text = Convert.ToString(Power[2]);
                    txtPower4.Text = Convert.ToString(Power[3]);
                    txtPower5.Text = Convert.ToString(Power[4]);
                    txtPower6.Text = Convert.ToString(Power[5]);
                    txtPower7.Text = Convert.ToString(Power[6]);
                    txtPower8.Text = Convert.ToString(Power[7]);
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetReaderPower", btGetPower.Text, fCmdRet);
        }

        private void btSetIp_Click(object sender, EventArgs e)
        {
            try
            {
                if ((txtIpaddr.Text == "") || (txtSubnet.Text == "") || (txtGateway.Text==""))
                {
                    return;
                }
                string[] temp1 = txtIpaddr.Text.Split('.');
                string[] temp2 = txtSubnet.Text.Split('.');
                string[] temp3 = txtGateway.Text.Split('.');
                if ((temp1.Length != 4) || (temp2.Length != 4) || (temp3.Length != 4))
                {
                    return;
                }
                byte[] ipAddr = new byte[4];
                byte[] SubnetMask= new byte[4];
                byte[] wgAddr=new byte[4];
                byte dhcp = 0;
                for (int i = 0; i < 4;i++ )
                {
                    ipAddr[i] = Convert.ToByte(temp1[i], 10);
                    SubnetMask[i] = Convert.ToByte(temp2[i], 10);
                    wgAddr[i] = Convert.ToByte(temp3[i], 10);
                }
                if (rb_dhcp.Checked) dhcp = 1;
                fCmdRet = MainForm.man.SetNetWorkIP(ipAddr, SubnetMask, wgAddr, dhcp);

            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetNetWorkIP", btSetIp.Text, fCmdRet);
        }

        private void btGetIp_Click(object sender, EventArgs e)
        {
            try
            {
                byte[] ipAddr = new byte[4];
                byte[] SubnetMask = new byte[4];
                byte[] wgAddr = new byte[4];
                byte dhcp = 0;
                txtIpaddr.Text ="";
                txtSubnet.Text = "";
                txtGateway.Text = "";
                fCmdRet = MainForm.man.GetNetWorkIP(ipAddr, SubnetMask, wgAddr,ref dhcp);
                if (fCmdRet==0)
                {
                    txtIpaddr.Text = ipAddr[0].ToString() + "." + ipAddr[1].ToString() + "." + ipAddr[2].ToString() + "." + ipAddr[3].ToString();
                    txtSubnet.Text = SubnetMask[0].ToString() + "." + SubnetMask[1].ToString() + "." + SubnetMask[2].ToString() + "." + SubnetMask[3].ToString();
                    txtGateway.Text = wgAddr[0].ToString() + "." + wgAddr[1].ToString() + "." + wgAddr[2].ToString() + "." + wgAddr[3].ToString();
                    if (dhcp == 1)
                        rb_dhcp.Checked = true;
                    else
                        rb_static.Checked = true;
                }

            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetNetWorkIP", btGetIp.Text, fCmdRet);
        }

        private void txtGateway_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789.".IndexOf(Char.ToUpper(e.KeyChar)) < 0);
        }

        private void btSetconnect_Click(object sender, EventArgs e)
        {
            try
            {
                if ((txtSvrIp.Text == "") || (txtSvrPort.Text == "") || (txtLoclPort.Text == ""))
                {
                    return;
                }
                string[] temp1 = txtSvrIp.Text.Split('.');
                if (temp1.Length != 4)
                {
                    return;
                }
                byte[] SvripAddr = new byte[4];
                int SvrPOrt=0;
                byte ConnectionMode=0;
                int ClientPort = 0;

                for (int i = 0; i < 4; i++)
                {
                    SvripAddr[i] = Convert.ToByte(temp1[i], 10);
                }
                SvrPOrt = Convert.ToInt32(txtSvrPort.Text, 10);
                ClientPort = Convert.ToInt32(txtLoclPort.Text, 10);
                ConnectionMode = (byte)com_contype.SelectedIndex;
                fCmdRet = MainForm.man.SetNetWorkConnection(SvripAddr, SvrPOrt, ConnectionMode, ClientPort);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetNetWorkConnection", btSetconnect.Text, fCmdRet);
        }

        private void btGetconnect_Click(object sender, EventArgs e)
        {
            try
            {
                txtSvrIp.Text = "";
                txtSvrPort.Text = "";
                txtLoclPort.Text = "";
                byte[] SvripAddr = new byte[4];
                int SvrPOrt = 0;
                byte ConnectionMode = 0;
                int ClientPort = 0;
                fCmdRet = MainForm.man.GetNetWorkConnection(SvripAddr,ref SvrPOrt,ref ConnectionMode,ref ClientPort);
                if (fCmdRet==0)
                {
                    txtSvrIp.Text = SvripAddr[0].ToString() + "." + SvripAddr[1].ToString() + "." + SvripAddr[2].ToString() + "." + SvripAddr[3].ToString();
                    txtSvrPort.Text = Convert.ToString(SvrPOrt,10);
                    txtLoclPort.Text = Convert.ToString(ClientPort,10);
                    com_contype.SelectedIndex = ConnectionMode;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetNetWorkConnection", btSetconnect.Text, fCmdRet);
        }

        private void btSetTimeout_Click(object sender, EventArgs e)
        {
            try
            {
                if (txtTimeout.Text == "") return;
                int TCPTimeOut = Convert.ToInt32(txtTimeout.Text,10);
                byte TCPReconnectMode = (byte)cbb_Reconnect.SelectedIndex;
                fCmdRet = MainForm.man.SetTimeoutAndReconnect(TCPTimeOut, TCPReconnectMode);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetTimeoutAndReconnect", btSetTimeout.Text, fCmdRet);
        }

        private void btGetTimeout_Click(object sender, EventArgs e)
        {
            try
            {
                int TCPTimeOut = 0;
                byte TCPReconnectMode = 0;
                txtTimeout.Text = "";
                fCmdRet = MainForm.man.GetTimeoutAndReconnect(ref TCPTimeOut,ref TCPReconnectMode);
                if (fCmdRet==0)
                {
                    txtTimeout.Text = TCPTimeOut.ToString();
                    cbb_Reconnect.SelectedIndex = TCPReconnectMode;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetTimeoutAndReconnect", btGetTimeout.Text, fCmdRet);
        }

        private void btSetAction_Click(object sender, EventArgs e)
        {
            try
            {
                byte[] actionen = new byte[4];
                actionen[0] = 0;
                if (check_acteas.Checked) actionen[0] |= 1;
                if (check_actonline.Checked) actionen[0] |= 2;
                if (check_actoffline.Checked) actionen[0] |= 4;
                fCmdRet = MainForm.man.SetActionEn(actionen);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetActionEn", btSetAction.Text, fCmdRet);
            /*try
            {
                byte BuzzOpenT, BuzzcloseT, BuzzCnt, BuzzVol, LEDEn, LEDOpenT, LEDCloseT, LEDCnt, Relay1T, Relay2T, BeepT;
               
                fCmdRet = MainForm.man.GetActionEn(actionen);
                if(check_actionen.Checked)
                {
                    switch(cbb_action.SelectedIndex)
                    {
                        case 0:
                            actionen[0] |= 0x01;
                            break;
                        case 1:
                            actionen[0] |= 0x02;
                            break;
                        case 2:
                            actionen[0] |= 0x04;
                            break;
                    }
                    
                }
                else
                {
                    switch (cbb_action.SelectedIndex)
                    {
                        case 0:
                            actionen[0] &= 0xFE;
                            break;
                        case 1:
                            actionen[0] &= 0xFD;
                            break;
                        case 2:
                            actionen[0] &= 0xFB;
                            break;
                    }
                }

               
                BuzzOpenT = Convert.ToByte(num_bzon.Value.ToString(),10);
                BuzzcloseT = Convert.ToByte(num_bzoff.Value.ToString(), 10);
                BuzzCnt = Convert.ToByte(num_bzcount.Value.ToString(), 10);
                BuzzVol = Convert.ToByte(num_bzvol.Value.ToString(), 10);

                LEDEn = 0;
                if (com_ch1.SelectedIndex == 1) LEDEn |= 0x01;
                if (com_ch2.SelectedIndex == 1) LEDEn |= 0x02;


                LEDOpenT = Convert.ToByte(num_ledon.Value.ToString(), 10);
                LEDCloseT = Convert.ToByte(num_ledoff.Value.ToString(), 10);
                LEDCnt = Convert.ToByte(num_ledcount.Value.ToString(), 10);

                Relay1T = Convert.ToByte(num_acrelay1.Value.ToString(), 10);
                Relay2T = Convert.ToByte(num_acrelay2.Value.ToString(), 10);

                BeepT = Convert.ToByte(num_acctlbz.Value.ToString(), 10);
                switch(cbb_action.SelectedIndex)
                {
                    case 0:
                        fCmdRet = MainForm.man.SetAlarmEventAction(BuzzOpenT, BuzzcloseT, BuzzCnt, BuzzVol, LEDEn, LEDOpenT, LEDCloseT, LEDCnt, Relay1T, Relay2T, BeepT);
                        break;
                    case 1:
                        fCmdRet = MainForm.man.SetPersionEnterEventAction(BuzzOpenT, BuzzcloseT, BuzzCnt, BuzzVol, LEDEn, LEDOpenT, LEDCloseT, LEDCnt, Relay1T, Relay2T, BeepT);
                        break;
                    case 2:
                        fCmdRet = MainForm.man.SetPersionLeaveEventAction(BuzzOpenT, BuzzcloseT, BuzzCnt, BuzzVol, LEDEn, LEDOpenT, LEDCloseT, LEDCnt, Relay1T, Relay2T, BeepT);
                        break;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetAlarmEventAction", btSetAction.Text, fCmdRet);*/
        }

        private void btGetAction_Click(object sender, EventArgs e)
        {
            try
            {
                byte[] actionen = new byte[4];
                check_acteas.Checked = false;
                check_actonline.Checked = false;
                check_actoffline.Checked = false;
                fCmdRet = MainForm.man.GetActionEn(actionen);
                if (fCmdRet == 0)
                {
                    if ((actionen[0] & 0x01) == 0x01)
                        check_acteas.Checked = true;
                    if ((actionen[0] & 0x02) == 0x02)
                        check_actonline.Checked = true;
                    if ((actionen[0] & 0x04) == 0x04)
                        check_actoffline.Checked = true;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetActionEn", btGetAction.Text, fCmdRet);

        }

        private void btGetClock_Click(object sender, EventArgs e)
        {
            Text_year.Text = "";
            Text_month.Text = "";
            Text_day.Text = "";
            Text_hour.Text = "";
            Text_min.Text = "";
            Text_sec.Text = "";
            byte[] Clocktime = new byte[6];
            fCmdRet = Device.GetClock(MainForm.man.ComAddr, Clocktime, MainForm.man.FrmHandle);
            if (fCmdRet == 0)
            {
                Text_year.Text = Convert.ToString(Clocktime[0], 10).PadLeft(2, '0');
                Text_month.Text = Convert.ToString(Clocktime[1], 10).PadLeft(2, '0');
                Text_day.Text = Convert.ToString(Clocktime[2], 10).PadLeft(2, '0');
                Text_hour.Text = Convert.ToString(Clocktime[3], 10).PadLeft(2, '0');
                Text_min.Text = Convert.ToString(Clocktime[4], 10).PadLeft(2, '0');
                Text_sec.Text = Convert.ToString(Clocktime[5], 10).PadLeft(2, '0');
            }
            AddCmdLog("GetClock", btGetClock.Text, fCmdRet);
        }

        private void btAction_EAS_Click(object sender, EventArgs e)
        {
            ActionForm act = new ActionForm();
            act.ActionType = 0;
            act.ShowDialog();
        }

        private void btAction_onLine_Click(object sender, EventArgs e)
        {
            ActionForm act = new ActionForm();
            act.ActionType = 1;
            act.ShowDialog();
        }

        private void btAction_offLine_Click(object sender, EventArgs e)
        {
            ActionForm act = new ActionForm();
            act.ActionType = 2;
            act.ShowDialog();
        }

        private void rb_static_CheckedChanged(object sender, EventArgs e)
        {
            txtIpaddr.Enabled = true;
            txtSubnet.Enabled = true;
            txtGateway.Enabled = true;
        }

        private void rb_dhcp_CheckedChanged(object sender, EventArgs e)
        {
            txtIpaddr.Enabled = false;
            txtSubnet.Enabled = false;
            txtGateway.Enabled = false;
        }

        private void btSetIrDelay_Click(object sender, EventArgs e)
        {
            byte InfraredTrigEn=0;
            byte DelayTime = 0;
            try
            {
                if (rb_irdisable.Checked)
                    InfraredTrigEn = 0;
                else
                    InfraredTrigEn = 1;

                DelayTime = Convert.ToByte(num_irdelay.Value.ToString(), 10);

                fCmdRet = MainForm.man.SetIrTriggerEn(InfraredTrigEn, DelayTime);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetIrTriggerEn", btSetIrDelay.Text, fCmdRet);
        }

        private void btGetIrDelay_Click(object sender, EventArgs e)
        {
            byte InfraredTrigEn = 0;
            byte DelayTime = 0;
            try
            {
                fCmdRet = MainForm.man.GetIrTriggerEn(ref InfraredTrigEn,ref DelayTime);
                if (fCmdRet==0)
                {
                    num_irdelay.Value = DelayTime;
                    if (InfraredTrigEn == 0)
                        rb_irdisable.Checked = true;
                    else
                        rb_irenable.Checked = true;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetIrTriggerEn", btGetIrDelay.Text, fCmdRet);
        }

        private void btClearPersonAlarm_Click(object sender, EventArgs e)
        {
            try
            {
                ulong online = 0;
                ulong inCount = 0;
                ulong outCount = 0;
                ulong AlarmCOunt = 0;
                byte[] btonline = new byte[4];
                byte[] btinCount = new byte[4];
                byte[] btoutCount = new byte[4];
                byte[] btAlarmCOunt = new byte[4];
                btonline[0] = (byte)(online >> 24);
                btonline[1] = (byte)((online >> 16) & 0x000000FF);
                btonline[2] = (byte)((online >> 8) & 0x000000FF);
                btonline[3] = (byte)(online & 0x000000FF);

                btinCount[0] = (byte)(inCount >> 24);
                btinCount[1] = (byte)((inCount >> 16) & 0x000000FF);
                btinCount[2] = (byte)((inCount >> 8) & 0x000000FF);
                btinCount[3] = (byte)(inCount & 0x000000FF);

                btoutCount[0] = (byte)(outCount >> 24);
                btoutCount[1] = (byte)((outCount >> 16) & 0x000000FF);
                btoutCount[2] = (byte)((outCount >> 8) & 0x000000FF);
                btoutCount[3] = (byte)(outCount & 0x000000FF);

                btAlarmCOunt[0] = (byte)(AlarmCOunt >> 24);
                btAlarmCOunt[1] = (byte)((AlarmCOunt >> 16) & 0x000000FF);
                btAlarmCOunt[2] = (byte)((AlarmCOunt >> 8) & 0x000000FF);
                btAlarmCOunt[3] = (byte)(AlarmCOunt & 0x000000FF);
                fCmdRet = Device.SetPersionAndAlarmInfo(MainForm.man.ComAddr, btinCount, btoutCount, btonline, btAlarmCOunt, MainForm.man.FrmHandle);

            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetPersionAndAlarmInfo", btClearPersonAlarm.Text, fCmdRet);
        }

        private void btSetAntenna_Click(object sender, EventArgs e)
        {

            try
            {
                byte antenna = 0;
                if (chk_ant1.Checked) antenna |= 0x01;
                if (chk_ant2.Checked) antenna |= 0x02;
                if (chk_ant3.Checked) antenna |= 0x04;
                if (chk_ant4.Checked) antenna |= 0x08;
                if (chk_ant5.Checked) antenna |= 0x10;
                if (chk_ant6.Checked) antenna |= 0x20;
                if (chk_ant7.Checked) antenna |= 0x40;
                if (chk_ant8.Checked) antenna |= 0x80;
                fCmdRet = MainForm.man.SetActiveAntenna(antenna);
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("SetActiveAntenna", btSetAntenna.Text, fCmdRet);
        }

        private void btGetAntenna_Click(object sender, EventArgs e)
        {
            try
            {
                byte antenna = 0;
                fCmdRet = MainForm.man.GetActiveAntenna(ref antenna);
                if(fCmdRet==0)
                {
                    if ((antenna & 0x01) == 0x01)
                        chk_ant1.Checked = true;
                    else
                        chk_ant1.Checked = false;

                    if ((antenna & 0x02) == 0x02)
                        chk_ant2.Checked = true;
                    else
                        chk_ant2.Checked = false;

                    if ((antenna & 0x04) == 0x04)
                        chk_ant3.Checked = true;
                    else
                        chk_ant3.Checked = false;

                    if ((antenna & 0x08) == 0x08)
                        chk_ant4.Checked = true;
                    else
                        chk_ant4.Checked = false;

                    if ((antenna & 0x10) == 0x10)
                        chk_ant5.Checked = true;
                    else
                        chk_ant5.Checked = false;

                    if ((antenna & 0x20) == 0x20)
                        chk_ant6.Checked = true;
                    else
                        chk_ant6.Checked = false;

                    if ((antenna & 0x40) == 0x40)
                        chk_ant7.Checked = true;
                    else
                        chk_ant7.Checked = false;

                    if ((antenna & 0x80) == 0x80)
                        chk_ant8.Checked = true;
                    else
                        chk_ant8.Checked = false;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetActiveAntenna", btGetAntenna.Text, fCmdRet);
        }

        private void btGetReturnloss_Click(object sender, EventArgs e)
        {
            try
            {
                txtloss1.Text = "";
                txtloss2.Text = "";
                txtloss3.Text = "";
                txtloss4.Text = "";
                txtloss5.Text = "";
                txtloss6.Text = "";
                txtloss7.Text = "";
                txtloss8.Text = "";
                txtloss1.Update();
                txtloss2.Update();
                txtloss3.Update();
                txtloss4.Update();
                txtloss5.Update();
                txtloss6.Update();
                txtloss7.Update();
                txtloss8.Update();
                for (int m = 0; m < 8;m++ )
                {
                    byte antenna = (byte)m;
                    byte returnloss = 0;
                    fCmdRet = Device.GetRerurnLoss(MainForm.man.ComAddr,antenna, ref returnloss, MainForm.man.FrmHandle);
                    if (fCmdRet==0)
                    {
                        switch(m)
                        {
                            case 0:
                                txtloss1.Text = Convert.ToString(returnloss).ToString();
                                txtloss1.Update();
                                break;
                            case 1:
                                txtloss2.Text = Convert.ToString(returnloss).ToString();
                                txtloss2.Update();
                                break;
                            case 2:
                                txtloss3.Text = Convert.ToString(returnloss).ToString();
                                txtloss3.Update();
                                break;
                            case 3:
                                txtloss4.Text = Convert.ToString(returnloss).ToString();
                                txtloss4.Update();
                                break;
                            case 4:
                                txtloss5.Text = Convert.ToString(returnloss).ToString();
                                txtloss5.Update();
                                break;
                            case 5:
                                txtloss6.Text = Convert.ToString(returnloss).ToString();
                                txtloss6.Update();
                                break;
                            case 6:
                                txtloss7.Text = Convert.ToString(returnloss).ToString();
                                txtloss7.Update();
                                break;
                            case 7:
                                txtloss8.Text = Convert.ToString(returnloss).ToString();
                                txtloss8.Update();
                                break;
                        }
                    }
                    
                    AddCmdLog("GetIrTriggerEn", btGetIrDelay.Text, fCmdRet);
                    if (fCmdRet == 0x30) break;
                }
                
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            
        }



        private void radioButton_EAS_CheckedChanged(object sender, EventArgs e)
        {
            gbp_alarmtype.Enabled = false;
            gbp_custom.Enabled = false;
        }

        private void radioButton_AFI_CheckedChanged(object sender, EventArgs e)
        {
            gbp_alarmtype.Enabled = true;
            if (rb_custom.Checked)
            {
                gbp_custom.Enabled = true;
            }
            else
            {
                gbp_custom.Enabled = false;
            }
        }

        private void rb_sh_CheckedChanged(object sender, EventArgs e)
        {
            gbp_custom.Enabled = false;
        }

        private void rb_ct_CheckedChanged(object sender, EventArgs e)
        {
            gbp_custom.Enabled = false;
        }

        private void rb_open_CheckedChanged(object sender, EventArgs e)
        {
            gbp_custom.Enabled = false;
        }

        private void rb_custom_CheckedChanged(object sender, EventArgs e)
        {
            gbp_custom.Enabled = true;
        }

        private void btGetMac_Click(object sender, EventArgs e)
        {
            try
            {
                txtMac1.Text = "";
                txtMac2.Text = "";
                txtMac3.Text = "";
                txtMac4.Text = "";
                txtMac5.Text = "";
                txtMac6.Text = "";
                byte[] mac = new byte[6];
                fCmdRet = Device.GetDeviceMAC(MainForm.man.ComAddr, mac, MainForm.man.FrmHandle);
                if (fCmdRet==0)
                {
                    txtMac1.Text = mac[0].ToString();
                    txtMac2.Text = mac[1].ToString();
                    txtMac3.Text = mac[2].ToString();
                    txtMac4.Text = mac[3].ToString();
                    txtMac5.Text = mac[4].ToString();
                    txtMac6.Text = mac[5].ToString();
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            AddCmdLog("GetDeviceMAC", btGetMac.Text, fCmdRet);
        }



    }
}
