﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;
using System.IO;
using Gate;
using System.Net;
using System.Net.Sockets;
namespace UHFGateDemo
{
    public partial class ConnectType : Form
    {
        public ConnectType()
        {
            InitializeComponent();
        }

        private void ConnectType_Load(object sender, EventArgs e)
        {
            if(MainForm.man.ipAddr!="")
            {
                tb_ip.Text = MainForm.man.ipAddr;
                tb_Port.Text = Convert.ToString(MainForm.man.tPort, 10);
            }
            
            if (MainForm.man.mType==0)
            {
                rb_rs232.Checked = true;
                gpb_rs232.Enabled = true;
                gpb_tcp.Enabled = false;
            }
            else
            {
                rb_tcp.Checked = true;
                gpb_rs232.Enabled = false;
                gpb_tcp.Enabled = true;
            }

            string[] sp;
            int i;
            sp = SerialPort.GetPortNames();
            for (i = 0; i < sp.Length; i++)
            {
                ComboBox_COM.Items.Add(sp[i]);
            }

        }

        private void rb_rs232_CheckedChanged(object sender, EventArgs e)
        {
            gpb_rs232.Enabled = true;
            gpb_tcp.Enabled = false;
        }

        private void rb_tcp_CheckedChanged(object sender, EventArgs e)
        {
            gpb_rs232.Enabled = false;
            gpb_tcp.Enabled = true;
        }

        private void btConnect_Click(object sender, EventArgs e)
        {
            MainForm.man.ComAddr = Convert.ToByte(textBox1.Text); 
            if(rb_rs232.Checked)
            {
                string strCom = ComboBox_COM.Text;
                if (strCom.Length>3)
                {
                    strCom = strCom.Substring(3);
                    MainForm.man.Port = Convert.ToInt32(strCom,10);
                    MainForm.man.mType = 0;
                }
                else
                {
                    MessageBox.Show("Select COM Port!!!");
                        return;
                }
            }
            else
            {
                if ((tb_ip.Text == "") || (tb_Port.Text ==""))
                {
                    return;
                }
                MainForm.man.ipAddr = tb_ip.Text;
                MainForm.man.tPort = Convert.ToInt32(tb_Port.Text, 10);
                MainForm.man.mType = 1;
            }
            this.DialogResult = DialogResult.OK;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            byte[] data = new byte[1024];
            try
            {
                DeviceListView.Items.Clear();
                DeviceListView.Update();
                Socket sock = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);//初始化一个Scoket实习,采用UDP传输
                IPEndPoint iep = new IPEndPoint(IPAddress.Broadcast, 65535);//初始化一个发送广播和指定端口的网络端口实例
                //IPEndPoint iep = new IPEndPoint(IPAddress.Parse("192.168.1.255"), 65535);//初始化一个发送广播和指定端口的网络端口实例
                EndPoint ep = (EndPoint)iep;
                sock.SetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Broadcast, 1);//设置该scoket实例的发送形式
                string request = "P";//初始化需要发送的数据
                byte[] buffer = Encoding.ASCII.GetBytes(request);
                sock.SendTo(buffer, iep);
                for (int i = 0; i < 255; i++)
                {
                    byte[] buf = new byte[1000];
                    sock.ReceiveTimeout = 50;
                    int m_count = sock.ReceiveFrom(buf, ref ep);
                    if (m_count == 25)
                    {
                        string[] btArr = new string[2];
                        //btArr[0] = Convert.ToString(DeviceListView.Items.Count + 1);
                        btArr[0] = buf[0].ToString() + "." + buf[1].ToString() + "." + buf[2].ToString() + "." + buf[3].ToString();
                        btArr[1] = Convert.ToString(buf[16] * 256 + buf[17],10);
                        bool isInlist = false;
                        for (int index = 0; index < DeviceListView.Items.Count; index++)
                        {
                            if (btArr[0] == DeviceListView.Items[index].SubItems[1].Text)
                            {
                                isInlist = true;
                                break;
                            }
                        }
                        if (!isInlist)
                        {
                            ListViewItem item = new ListViewItem(btArr);
                            DeviceListView.Items.Add(item);
                        }
                    }
                }
                sock.Close();
            }
            catch (System.Exception ex)
            {
                ex.ToString();
                return;
            }
        }

        private void DeviceListView_DoubleClick(object sender, EventArgs e)
        {
            if (this.DeviceListView.SelectedIndices.Count > 0 && this.DeviceListView.SelectedIndices[0] != -1)
            {
                tb_ip.Text = DeviceListView.SelectedItems[0].SubItems[0].Text;
                tb_Port.Text = DeviceListView.SelectedItems[0].SubItems[1].Text;
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //开启IE访问目标设备；
            try
            {
                if (DeviceListView.SelectedIndices.Count > 0
                    && DeviceListView.SelectedIndices[0] != -1)
                {
                    string ipStr = DeviceListView.SelectedItems[0].SubItems[0].Text;
                    System.Diagnostics.Process.Start("iexplore.exe", "HTTP://" + ipStr);
                }
            }
            catch (Exception ex)
            {
                ex.ToString();
            }
        }
    }
}
