﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Threading;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using Gate;
namespace UHFGateDemo
{
    public partial class MainForm : Form
    {
        [DllImport("User32.dll", EntryPoint = "PostMessage")]
        private static extern int PostMessage( IntPtr hWnd,uint Msg,uint wParam, uint lParam);

        [DllImport("User32.dll", EntryPoint = "SendMessage")]
        private static extern int SendMessage(IntPtr hwnd, int wMsg, IntPtr wParam, string lParam);

        [DllImport("User32.dll", EntryPoint = "FindWindow")]
        private static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        public const int USER = 0x0400;
        public const int WM_SENDTAG = USER + 101;
        public const int WM_SENDEAS = USER + 102;
        public const int WM_SENDPERSON = USER + 103;
        public const int WM_SENDIR = USER + 104;
        public const int WM_SENDCLEAR = USER + 105;
        public const int WM_SENDRESULT = USER + 106;

        public static Manager man = new Manager();
        int fCmdRet = 0x30;
        public MainForm()
        {
            InitializeComponent();
            man.isConnect = false;
            man.mType = 0;
            man.ComAddr = 255;
        }
        bool inDecNum(string temp)
        {
            string hexStr = "0123456789ABCDEF";
            bool success =true;
            for (int m = 0; m < temp.Length;m++ )
            {
                string nchar = temp.Substring(m, 1);
                if (hexStr.IndexOf(nchar)==-1)
                {
                    success=false;
                    break;
                }
            }
            return success;
        }
        protected override void DefWndProc(ref Message m)
        {
            if (m.Msg == WM_SENDTAG)
            {
                string  Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0,2),16).ToString().PadLeft(2,'0')+" "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0')+":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');
                string epc = btArr[1];

                string[] arr = new string[4];
                arr[0] = (dataGridView1.Rows.Count + 1).ToString();
                arr[1] = epc;
                arr[2] = "1";
                arr[3] = strtime;

                bool inlist = false;
                for (int index = 0; index < dataGridView1.RowCount; index++)
                {
                    if (dataGridView1.Rows[index].Cells[1].Value.ToString().Equals(btArr[1]))
                    {
                        string CountStr = dataGridView1.Rows[index].Cells[2].Value.ToString();
                        if (!inDecNum(CountStr))
                        {
                            continue;
                        }
                        int Count = Convert.ToInt32(CountStr, 10);
                        Count++;
                        dataGridView1.Rows[index].Cells[2].Value = Count;
                        dataGridView1.Rows[index].Cells[3].Value = strtime;
                        inlist = true;
                        break;
                    }
                }
                if (!inlist) dataGridView1.Rows.Add(arr);
                txtNum.Text = dataGridView1.RowCount.ToString();

            }
            else if (m.Msg == WM_SENDEAS)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0, 2), 16).ToString().PadLeft(2, '0') + " "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');
                string EAS_Type = "";
                string epc = "";
                if (btArr[1] == "0")
                {
                    epc = btArr[2];
                    EAS_Type = "No Alarm";
                }
                else if (btArr[1] == "2")
                {
                    epc = btArr[2];
                    EAS_Type = "Emulated EAS Alarm";
                }
                else
                {
                    epc = "None";
                    EAS_Type = "EAS Alarm(NXP)";
                }
                
                string[] arr = new string[4];
                arr[0] = (dataGridView1.Rows.Count + 1).ToString();
                arr[1] = epc;
                arr[2] = EAS_Type;
                arr[3] = strtime;

                dataGridView1.Rows.Add(arr);
                //dataGridView1.Update();
            }
            else if (m.Msg == WM_SENDPERSON)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0, 2), 16).ToString().PadLeft(2, '0') + " "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');
                //txtOnlie.Text = btArr[4];
                txtIn.Text = btArr[2];
                txtOut.Text = btArr[3];
                if (btArr[1]=="0")
                {
                    txtStatus.Text = "Forward";
                }
                else if (btArr[1] == "1")
                {
                    txtStatus.Text = "Backward";
                }
                else
                {
                    txtStatus.Text = "Indefinite";
                }
            }
            else if (m.Msg == WM_SENDIR)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0, 2), 16).ToString().PadLeft(2, '0') + " "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');

                string IRNum = btArr[1];
                string IRactive = btArr[2];
                int irdir = Convert.ToInt32(IRactive, 10);
                int Num = Convert.ToInt32(IRNum, 10);
                if (Num == 0)
                {
                    if(irdir==0)
                    {
                        pic_ir1.BackgroundImage = (Image)Properties.Resources.pRed;
                    }
                    else
                    {
                        pic_ir1.BackgroundImage = (Image)Properties.Resources.pGray;
                    }
                }
                else if(Num==1)
                {
                    if (irdir == 0)
                    {
                        pic_ir2.BackgroundImage = (Image)Properties.Resources.pRed;
                    }
                    else
                    {
                        pic_ir2.BackgroundImage = (Image)Properties.Resources.pGray;
                    }
                }
                else if(Num==2)
                {
                    if (irdir == 0)
                    {
                        pic_ir3.BackgroundImage = (Image)Properties.Resources.pRed;
                    }
                    else
                    {
                        pic_ir3.BackgroundImage = (Image)Properties.Resources.pGray;
                    }
                }
                else if(Num==3)
                {
                    if (irdir == 0)
                    {
                        pic_ir4.BackgroundImage = (Image)Properties.Resources.pRed;
                    }
                    else
                    {
                        pic_ir4.BackgroundImage = (Image)Properties.Resources.pGray;
                    }
                }
            }
            else if (m.Msg == WM_SENDCLEAR)
            {
                try
                {
                    txtNum.Text = "0";
                    txtTime.Text = "00:00:00";
                    //txtOnlie.Text = "0";
                    txtIn.Text = "0";
                    txtOut.Text = "0";
                    txtStatus.Text = "";
                    beginTime = System.Environment.TickCount;
                    dataGridView1.DataSource = null;
                    dataGridView1.Rows.Clear();
                   // dataGridView1.Update();
                }
                catch (System.Exception ex)
                {
                    ex.ToString();
                }
                
            }
            else if(m.Msg == WM_SENDRESULT)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                fCmdRet = Convert.ToInt32(Info, 10);
                AddCmdLog("GetChannelMessage", "Get Channel Message", fCmdRet);
            }
            else
                base.DefWndProc(ref m);
        }

        #region  16进制字符串到数组之间的相互转换
        private byte[] HexStringToByteArray(string s)
        {
            s = s.Replace(" ", "");
            if ((s.Length % 2) != 0)
                s += "0";
            byte[] buffer = new byte[s.Length / 2];
            for (int i = 0; i < s.Length; i += 2)
                buffer[i / 2] = (byte)Convert.ToByte(s.Substring(i, 2), 16);
            return buffer;
        }
        private string ByteArrayToHexString(byte[] data)
        {
            StringBuilder sb = new StringBuilder(data.Length * 3);
            foreach (byte b in data)
                sb.Append(Convert.ToString(b, 16).PadLeft(2, '0').PadRight(3, ' '));
            return sb.ToString().ToUpper();
        }
        #endregion

        private string GetReturnCodeDesc(int cmdRet)
        {
            switch (cmdRet)
            {
                case 0x00:
                    return "Success";
                case 0x01:
                    return "Command length error";
                case 0x02:
                    return "Command Not support ";
                case 0x03:
                    return "Parameter range error ";
                case 0x04:
                    return "Command can not doing at this moment ";
                case 0x06:
                    return "FLASH operate error";
                case 0x07:
                    return "Command operate error";
                case 0x31:
                    return "CRC check error";
                case 0x30:
                    return "Communication error";
                case 0x37:
                    return "Invalid handle";
                case 0xEE:
                    return "Command code error";
                default:
                    return "Unknown error";
            }
        }

        private void AddCmdLog(string CMD, string cmdStr, int cmdRet)
        {
            try
            {
                StatusBar1.Panels[0].Text = "";
                StatusBar1.Panels[0].Text = DateTime.Now.ToLongTimeString() + " " +
                                            cmdStr + ": " +
                                            GetReturnCodeDesc(cmdRet);
            }
            finally
            {
                ;
            }
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
           try
           {
               ConnectType con = new ConnectType();
               DialogResult result = con.ShowDialog();
               lbVersion.Text = "";
               if (result == DialogResult.OK)
               {

                   if (man.mType == 0)
                   {
                       fCmdRet = Device.OpenComPort(man.Port, ref man.ComAddr, ref man.FrmHandle);
                   }
                   else
                   {
                       fCmdRet = Device.OpenNetPort(man.tPort, man.ipAddr, ref man.ComAddr, ref man.FrmHandle);
                   }
                   if (fCmdRet == 0)
                   {
                       byte WorkMode = 0;
                       fCmdRet = MainForm.man.GetWorkMode(ref WorkMode);
                       if (fCmdRet == 0)
                       {
                           man.WorkMode = WorkMode;
                           if (WorkMode == 0)
                           {
                               dataGridView1.Columns[0].HeaderText = "No.";
                               dataGridView1.Columns[1].HeaderText = "EPC/TID";
                               dataGridView1.Columns[2].HeaderText = "Count";
                               dataGridView1.Columns[3].HeaderText = "Time";
                           }
                           else
                           {


                               dataGridView1.Columns[0].HeaderText = "No.";
                               dataGridView1.Columns[1].HeaderText = "EPC/TID";
                               dataGridView1.Columns[2].HeaderText = "Alarm Status";
                               dataGridView1.Columns[3].HeaderText = "Time";
                           }
                       }

                       byte ProductCode = 0;
                       byte[] Version = new byte[2];
                       byte[] DevSN = new byte[4];
                       lbVersion.Text = "";
                       fCmdRet = Device.GetControllerInfo(ref MainForm.man.ComAddr, ref ProductCode, Version, DevSN, MainForm.man.FrmHandle);
                       if (fCmdRet == 0)
                       {
                           lbVersion.Text = "Version:"+Convert.ToString(ProductCode, 10)+"-"
                               + Convert.ToString(Version[0], 10).PadLeft(2, '0') + "." + Convert.ToString(Version[1], 10).PadLeft(2, '0')+"-"
                               + ByteArrayToHexString(DevSN).Replace(" ","");
                       }

                       EnableButton();
                   }
                   AddCmdLog("Connect", "Connect", fCmdRet);
               }

           }
           catch (System.Exception ex)
           {
               ex.ToString();
           }
        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            try
            {
                beginScan = false;
                //timer1.Enabled = false;
                timer2.Enabled = false;
                if (man.mType == 0)
                {
                    if (man.FrmHandle > 0)
                    {
                        int result = Device.CloseSpecComPort(man.FrmHandle);
                        DisableButton();
                        man.isConnect = false;
                        man.FrmHandle = -1;
                        lbVersion.Text = "";
                        dataGridView1.Rows.Clear();
                    }
                }
                else
                {
                    if (man.FrmHandle > 0)
                    {
                        int result = Device.CloseNetPort(man.FrmHandle);
                        DisableButton();
                        man.isConnect = false;
                        man.FrmHandle = -1;
                        lbVersion.Text = "";
                        dataGridView1.Rows.Clear();
                    }
                }
            }
            catch (System.Exception ex)
            {
                dataGridView1.Rows.Clear();
                lbVersion.Text = "";
                ex.ToString();
            }
            
        }

        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            ConfigForm cf = new ConfigForm();
            cf.gbView1 = dataGridView1;
            cf.ShowDialog();
        }


        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            Close();
        }
       


        public void DisableButton()
        {
            btConnect.Enabled = true;
            btDisConnect.Enabled = false;
            btConfig.Enabled = false;
            btStart.Enabled = false;
            btStop.Enabled = false;
            btLoaddefault.Enabled = false;
            btRestart.Enabled = false;
            //btUpdate.Enabled = false;

        }

        public void EnableButton()
        {
            btConnect.Enabled = false;
            btDisConnect.Enabled = true;
            btConfig.Enabled = true;
            btStart.Enabled = true;
            btStop.Enabled = false;
            btLoaddefault.Enabled = true;
            btRestart.Enabled = true;
            //btUpdate.Enabled = true;
        }
        private void Form1_Load(object sender, EventArgs e)
        {
            lbonline.Width = 300;
            dataGridView1.Width = this.Width - 300;
            dataGridView1.Columns[0].Width = ((dataGridView1.Width - 50) / 10);
            dataGridView1.Columns[1].Width = ((dataGridView1.Width - 50) / 10) * 5;
            dataGridView1.Columns[2].Width = ((dataGridView1.Width - 50) / 10) * 2;
            dataGridView1.Columns[3].Width = ((dataGridView1.Width - 50) / 10) * 2;
            dataGridView1.Height = this.Height - 74;
            DisableButton();
           
        }

        private void MainForm_Resize(object sender, EventArgs e)
        {
            try
            {
                ///Normal size
                if (this.WindowState == FormWindowState.Normal)
                {
                    this.ShowInTaskbar = true; //This form is not displayed in the taskbar    
                    this.MaximizeBox = true;
                    //  this.WindowState = FormWindowState.Maximized;
                }
                lbonline.Width = 300;
                dataGridView1.Width = this.Width - 300;
                dataGridView1.Columns[0].Width = ((dataGridView1.Width - 50) / 10);
                dataGridView1.Columns[1].Width = ((dataGridView1.Width - 50) / 10) * 5;
                dataGridView1.Columns[2].Width = ((dataGridView1.Width - 50) / 10) * 2;
                dataGridView1.Columns[3].Width = ((dataGridView1.Width - 50) / 10) * 2;
                dataGridView1.Height = this.Height - 74;
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
        }

        Button bt = new Button();

        private void bt_Click(object sender, EventArgs e)
        {
            if(bt.Text =="Show")
            {
                bt.Text = "Hide";
                dataGridView1.Columns[5].Visible = true;
                dataGridView1.Columns[6].Visible = true;
                dataGridView1.Columns[9].Visible = true;
                dataGridView1.Columns[10].Visible = true;
                dataGridView1.Columns[11].Visible = true;
                dataGridView1.Columns[12].Visible = true;
                dataGridView1.Columns[13].Visible = true;
            }
            else
            {
                bt.Text = "Show";
                dataGridView1.Columns[5].Visible = false;
                dataGridView1.Columns[6].Visible = false;
                dataGridView1.Columns[9].Visible = false;
                dataGridView1.Columns[10].Visible = false;
                dataGridView1.Columns[11].Visible = false;
                dataGridView1.Columns[12].Visible = false;
                dataGridView1.Columns[13].Visible = false;
            }
        }

        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            timer2.Enabled = false;
            beginScan = false;
        }

     

       

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {

        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {

        }

        volatile bool beginScan = false;
        long beginTime = 0;
        Thread readThread1 = null;
        private void btStart_Click(object sender, EventArgs e)
        {
            btrefresh_Click(null,null);
            btConfig.Enabled = false;
            btStart.Enabled = false;
            btStop.Enabled = true;
            btLoaddefault.Enabled = false;
            btRestart.Enabled = false;
            beginScan = true;
            btUpdate.Enabled = false;
            //timer1.Enabled = true;
            timer2.Enabled = true;
            beginTime = System.Environment.TickCount;
            readThread1 = new Thread(GetMessage);
            readThread1.IsBackground = true;
            readThread1.Start();
        }

        private void btTcpConfig_Click(object sender, EventArgs e)
        {

        }

        private void btrefresh_Click(object sender, EventArgs e)
        {
            IntPtr ptrWnd1 = IntPtr.Zero;
            ptrWnd1 = FindWindow(null, "UHFGate Demo Software V1.0.0");
            if (ptrWnd1 != IntPtr.Zero)        
            {
                SendMessage(ptrWnd1, WM_SENDCLEAR, IntPtr.Zero, "");
            }
        }


        private void GetMessage()
        {
            try
            {
                byte[] Msg = new byte[256];
                byte MsgLength;
                byte MsgType;
                byte PacketNo;
                IntPtr ptrWnd1 = IntPtr.Zero;
                ptrWnd1 = FindWindow(null, "UHFGate Demo Software V1.0.0");
               
                while (beginScan)
                {
                    MsgLength = 0;
                    MsgType = 0;
                    PacketNo = 0;
                    fCmdRet = Device.GetChannelMessage(man.ComAddr, ref PacketNo,Msg, ref MsgLength, ref MsgType, man.FrmHandle);
                    if ((fCmdRet == 0) && (MsgLength>0))
                    {
                        if (MsgType == 0)//Empty message response, not processed
                        {
                            ;
                        }
                        else if (MsgType == 1)//Inventory message response
                        {
                            byte[] AyTime = new byte[6];
                            Array.Copy(Msg, 0, AyTime, 0, 6);//time
                            int Number = Msg[6];//A number of
                            if (Number == 1)
                            {
                                int EPCLen = Msg[7];//Length of EPC number
                                byte[] EPC = new byte[EPCLen];
                                Array.Copy(Msg, 8, EPC, 0, EPCLen);//EPC number of the label

                                if (ptrWnd1 != IntPtr.Zero)    
                                {
                                    string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                                    para += ",";
                                    para += ByteArrayToHexString(EPC);
                                    SendMessage(ptrWnd1, WM_SENDTAG, IntPtr.Zero, para);
                                }
                            }

                        }
                        else if (MsgType == 2)//EAS alarm message response
                        {
                            byte[] AyTime = new byte[6];
                            Array.Copy(Msg, 0, AyTime, 0, 6);//time
                            int EAS_Type = Msg[6];//Message type: 0- No alarm, 2- alarm
                            if ((EAS_Type == 0) || (EAS_Type == 2))
                            {
                                int EPCLen = Msg[7];//Length of EPC number
                                byte[] EPC = new byte[EPCLen];
                                Array.Copy(Msg, 8, EPC, 0, EPCLen);//The EPC number
                                if (ptrWnd1 != IntPtr.Zero)    
                                {
                                    string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                                    para += ",";
                                    para += EAS_Type.ToString();
                                    para += ",";
                                    para += ByteArrayToHexString(EPC);
                                    SendMessage(ptrWnd1, WM_SENDEAS, IntPtr.Zero, para);
                                }
                            }
                            else//Standard EAS alarm
                            {
                                if (ptrWnd1 != IntPtr.Zero)  
                                {
                                    string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                                    para += ",";
                                    para += EAS_Type.ToString();
                                    SendMessage(ptrWnd1, WM_SENDEAS, IntPtr.Zero, para);
                                }
                            }
                        }
                        else if (MsgType == 3)//Personnel message response
                        {
                            byte[] AyTime = new byte[6];
                            Array.Copy(Msg, 0, AyTime, 0, 6);//时间
                            int dir_Type = Msg[6];//方向

                            int positive = (Msg[7] << 24) + (Msg[8] << 16) + (Msg[9] << 8) + Msg[10];//positive
                            int reverse = (Msg[11] << 24) + (Msg[12] << 16) + (Msg[13] << 8) + Msg[14];//reverse
                            int Online = (Msg[15] << 24) + (Msg[16] << 16) + (Msg[17] << 8) + Msg[18];//Number of visitors

                            if (ptrWnd1 != IntPtr.Zero)         // Check whether the current statistics window is open
                            {
                                string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                                para += ",";
                                para += dir_Type.ToString();
                                para += ",";
                                para += positive.ToString();
                                para += ",";
                                para += reverse.ToString();
                                para += ",";
                                para += Online.ToString();
                                SendMessage(ptrWnd1, WM_SENDPERSON, IntPtr.Zero, para);
                            }

                        }
                        else if (MsgType == 4)//Infrared message response
                        {
                            byte[] AyTime = new byte[6];
                            Array.Copy(Msg, 0, AyTime, 0, 6);//time
                            int Num = Msg[6];//Infrared numbering
                            int IRactive = Msg[7];//Infrared action (blocking or)

                            if (ptrWnd1 != IntPtr.Zero)         // Check whether the current statistics window is open
                            {
                                string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                                para += ",";
                                para += Num.ToString();
                                para += ",";
                                para += IRactive.ToString();
                                SendMessage(ptrWnd1, WM_SENDIR, IntPtr.Zero, para);
                            }
                        }
                        Device.Acknowledge(man.ComAddr, man.FrmHandle);
                    }
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }

            this.Invoke((EventHandler)delegate
            {
                if( man.FrmHandle >0)
                {
                    btConfig.Enabled = true;
                    btStart.Enabled = true;
                    btStop.Enabled = false;
                    btLoaddefault.Enabled = true;
                    btRestart.Enabled = true;
                    timer2.Enabled = false;
                    btUpdate.Enabled = true;
                }
            });
          
        }
        //
        private void timer2_Tick(object sender, EventArgs e)
        {
            long runTime = System.Environment.TickCount - beginTime;
            long millsecond = runTime % 1000;
            long totalsecond = (runTime / 1000);
            long minute = (totalsecond / 60);
            long second = totalsecond % 60;
            txtTime.Text = minute.ToString().PadLeft(2, '0') + ":" + second.ToString().PadLeft(2, '0') + ":" + millsecond.ToString().PadLeft(3, '0');
            //txtTime.Update();
        }

        private void toolStrip1_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {

        }

        private void btLoaddefault_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show(this, "Load default?", "Information", MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                return;
            fCmdRet = Device.LoadDefault(man.ComAddr, man.FrmHandle);
            AddCmdLog("LoadDefault", "Load default", fCmdRet);
        }

        private void btRestart_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show(this, "Restart?", "Information", MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                return;
            fCmdRet = Device.ControllerRestart(man.ComAddr, man.FrmHandle);
            AddCmdLog("ControllerRestart", "Restart", fCmdRet);
        }

        private void btUpdate_Click(object sender, EventArgs e)
        {
            updateForm up = new updateForm();
            up.ShowDialog();
        }

    }
}