const {SerialPort} = require("serialport"); //引入模块
const {output:{send},income}=require('./UHFlib');

const portName = '/dev/ttyUSB0'; //定义串口名
const port = new SerialPort({path:portName,baudRate:57600,autoOpen:false});
port.open(error=> {
    if(error)return console.log(error);

    const data=send.getInfo();
    port.write(data);
    // port.write(output.send.scan.epc());
});

let tmr=0;
port.on('data', buf=> {
    const data=income.decode(buf),{cmd,status}=data;
    //连接上，开始扫描标签
    if(cmd===33 && status===0){
        (function fn(){
            clearTimeout(tmr);
            port.write(send.scanEpc());
            // port.write(send.writeEpc('qwerty'));
            tmr=setTimeout(fn,100);
        })();
    }else if(cmd===1&&status===1&&data.items[0]){
        for(const {epc} of data.items) console.log(epc.toString('utf8'));
    }else console.log(data);
});