﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Threading;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using Gate;
namespace UHFGateDemo
{
    public partial class MainForm : Form
    {
        [DllImport("User32.dll", EntryPoint = "PostMessage")]
        private static extern int PostMessage( IntPtr hWnd,uint Msg,uint wParam, uint lParam);

        [DllImport("User32.dll", EntryPoint = "SendMessage")]
        private static extern int SendMessage(IntPtr hwnd, int wMsg, IntPtr wParam, string lParam);

        [DllImport("User32.dll", EntryPoint = "FindWindow")]
        private static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        public const int USER = 0x0400;
        public const int WM_SENDTAG = USER + 101;
        public const int WM_SENDEAS = USER + 102;
        public const int WM_SENDPERSON = USER + 103;
        public const int WM_SENDIR = USER + 104;
        public const int WM_SENDCLEAR = USER + 105;
        public const int WM_SENDRESULT = USER + 106;

        public const int WM_SENDINVRSSI = USER + 107;
        public const int WM_SENDEASRSSI = USER + 108;
        public const int WM_SENDINVPHASE = USER + 109;
        public const int WM_SENEASPHASE = USER + 110;

        private static object LockFlag = new object();
        public static Manager man = new Manager();
        int fCmdRet = 0x30;
        public MainForm()
        {
            InitializeComponent();
            man.isConnect = false;
            man.mType = 0;
            man.ComAddr = 255;
        }
        bool inDecNum(string temp)
        {
            string hexStr = "0123456789ABCDEF";
            bool success =true;
            for (int m = 0; m < temp.Length;m++ )
            {
                string nchar = temp.Substring(m, 1);
                if (hexStr.IndexOf(nchar)==-1)
                {
                    success=false;
                    break;
                }
            }
            return success;
        }

        List<string> mlist = new List<string>();
        protected override void DefWndProc(ref Message m)
        {
            if (m.Msg == WM_SENDTAG)
            {
                string  Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0,2),16).ToString().PadLeft(2,'0')+" "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0')+":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');
                string epc = btArr[1];

                string[] arr = new string[7];
                arr[0] = (dataGridView1.Rows.Count + 1).ToString();
                arr[1] = epc;
                arr[5] = "1";
                arr[6] = strtime;

                int findIndex = mlist.IndexOf(epc);
                if (findIndex == -1)
                {
                    mlist.Add(epc);
                    dataGridView1.Rows.Add(arr);
                }
                else
                {
                    string CountStr = dataGridView1.Rows[findIndex].Cells[5].Value.ToString();
                    if (!inDecNum(CountStr))
                    {
                        return;
                    }
                    int Count = Convert.ToInt32(CountStr, 10);
                    Count++;
                    dataGridView1.Rows[findIndex].Cells[5].Value = Count;
                    dataGridView1.Rows[findIndex].Cells[6].Value = strtime;
                }
                txtNum.Text = dataGridView1.RowCount.ToString();

            }
            else if (m.Msg == WM_SENDEAS)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0, 2), 16).ToString().PadLeft(2, '0') + " "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');
                string EAS_Type = "";
                string epc = "";
                if (btArr[1] == "0")
                {
                    epc = btArr[2];
                    EAS_Type = "未报警";
                }
                else if (btArr[1] == "2")
                {
                    epc = btArr[2];
                    EAS_Type = "仿真EAS报警";
                }
                else
                {
                    epc = "无";
                    EAS_Type = "标准EAS报警(NXP)";
                }
                
                string[] arr = new string[7];
                arr[0] = (dataGridView1.Rows.Count + 1).ToString();
                arr[1] = epc;
                arr[5] = EAS_Type;
                arr[6] = strtime;

                dataGridView1.Rows.Add(arr);
                //dataGridView1.Update();
            }
            else if (m.Msg == WM_SENDPERSON)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0, 2), 16).ToString().PadLeft(2, '0') + " "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');
                txtOnlie.Text = btArr[4];
                txtIn.Text = btArr[2];
                txtOut.Text = btArr[3];
                if (btArr[1]=="0")
                {
                    txtStatus.Text = "进馆";
                }
                else if (btArr[1] == "1")
                {
                    txtStatus.Text = "出馆";
                }
                else
                {
                    txtStatus.Text = "方向不定";
                }
            }
            else if (m.Msg == WM_SENDIR)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0, 2), 16).ToString().PadLeft(2, '0') + " "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');

                string IRNum = btArr[1];
                string IRactive = btArr[2];
                int irdir = Convert.ToInt32(IRactive, 10);
                int Num = Convert.ToInt32(IRNum, 10);
                if (Num == 0)
                {
                    if(irdir==0)
                    {
                        pic_ir1.BackgroundImage = (Image)Properties.Resources.pRed;
                    }
                    else
                    {
                        pic_ir1.BackgroundImage = (Image)Properties.Resources.pGray;
                    }
                }
                else if(Num==1)
                {
                    if (irdir == 0)
                    {
                        pic_ir2.BackgroundImage = (Image)Properties.Resources.pRed;
                    }
                    else
                    {
                        pic_ir2.BackgroundImage = (Image)Properties.Resources.pGray;
                    }
                }
                else if(Num==2)
                {
                    if (irdir == 0)
                    {
                        pic_ir3.BackgroundImage = (Image)Properties.Resources.pRed;
                    }
                    else
                    {
                        pic_ir3.BackgroundImage = (Image)Properties.Resources.pGray;
                    }
                }
                else if(Num==3)
                {
                    if (irdir == 0)
                    {
                        pic_ir4.BackgroundImage = (Image)Properties.Resources.pRed;
                    }
                    else
                    {
                        pic_ir4.BackgroundImage = (Image)Properties.Resources.pGray;
                    }
                }
            }
            else if (m.Msg == WM_SENDCLEAR)
            {
                try
                {
                    curList.Clear();
                    msgList.Clear();
                    mlist.Clear();
                    txtNum.Text = "0";
                    txtTime.Text = "00:00:00";
                    txtOnlie.Text = "0";
                    txtIn.Text = "0";
                    txtOut.Text = "0";
                    txtStatus.Text = "";
                    beginTime = System.Environment.TickCount;
                    dataGridView1.DataSource = null;
                    dataGridView1.Rows.Clear();
                   // dataGridView1.Update();
                }
                catch (System.Exception ex)
                {
                    ex.ToString();
                }
                
            }
            if (m.Msg == WM_SENDINVRSSI)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0, 2), 16).ToString().PadLeft(2, '0') + " "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');
                string epc = btArr[1];
                string rssi = btArr[2];
                string[] arr = new string[7];
                arr[0] = (dataGridView1.Rows.Count + 1).ToString();
                arr[1] = epc;
                arr[2] = rssi;
                arr[5] = "1";
                arr[6] = strtime;

                int findIndex = mlist.IndexOf(epc);
                if (findIndex == -1)
                {
                    mlist.Add(epc);
                    dataGridView1.Rows.Add(arr);
                }
                else
                {
                    string CountStr = dataGridView1.Rows[findIndex].Cells[5].Value.ToString();
                    if (!inDecNum(CountStr))
                    {
                        return;
                    }
                    int Count = Convert.ToInt32(CountStr, 10);
                    Count++;
                    dataGridView1.Rows[findIndex].Cells[2].Value = rssi;
                    dataGridView1.Rows[findIndex].Cells[3].Value = "0";
                    dataGridView1.Rows[findIndex].Cells[4].Value = "0";
                    dataGridView1.Rows[findIndex].Cells[5].Value = Count;
                    dataGridView1.Rows[findIndex].Cells[6].Value = strtime;
                }
                txtNum.Text = dataGridView1.RowCount.ToString();

            }
            else if (m.Msg == WM_SENDEASRSSI)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0, 2), 16).ToString().PadLeft(2, '0') + " "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');
                string EAS_Type = "";
                string epc = "";
                if (btArr[1] == "0")
                {
                    epc = btArr[2];
                    EAS_Type = "未报警";
                }
                else if (btArr[1] == "2")
                {
                    epc = btArr[2];
                    EAS_Type = "仿真EAS报警";
                }
                string rssi = btArr[3];

                string[] arr = new string[7];
                arr[0] = (dataGridView1.Rows.Count + 1).ToString();
                arr[1] = epc;
                arr[2] = rssi;
                arr[5] = EAS_Type;
                arr[6] = strtime;

                dataGridView1.Rows.Add(arr);
                //dataGridView1.Update();
            }
            if (m.Msg == WM_SENDINVPHASE)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0, 2), 16).ToString().PadLeft(2, '0') + " "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');
                string epc = btArr[1];
                string rssi = btArr[2];
                string phase = btArr[3];
                string freq = btArr[4];
                string[] arr = new string[7];
                arr[0] = (dataGridView1.Rows.Count + 1).ToString();
                arr[1] = epc;
                arr[2] = rssi;
                arr[3] = phase;
                arr[4] = freq;
                arr[5] = "1";
                arr[6] = strtime;

                int findIndex = mlist.IndexOf(epc);
                if (findIndex == -1)
                {
                    mlist.Add(epc);
                    dataGridView1.Rows.Add(arr);
                }
                else
                {
                    string CountStr = dataGridView1.Rows[findIndex].Cells[5].Value.ToString();
                    if (!inDecNum(CountStr))
                    {
                        return;
                    }
                    int Count = Convert.ToInt32(CountStr, 10);
                    Count++;
                    dataGridView1.Rows[findIndex].Cells[2].Value = rssi;
                    dataGridView1.Rows[findIndex].Cells[3].Value = phase;
                    dataGridView1.Rows[findIndex].Cells[4].Value = freq;
                    dataGridView1.Rows[findIndex].Cells[5].Value = Count;
                    dataGridView1.Rows[findIndex].Cells[6].Value = strtime;
                }

               
                txtNum.Text = dataGridView1.RowCount.ToString();

            }
            else if (m.Msg == WM_SENEASPHASE)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                string[] btArr = Info.Split(',');
                DateTime dt = DateTime.Now;
                string strtime = dt.Year.ToString() + "-" + dt.Month.ToString().PadLeft(2, '0') + "-" + Convert.ToInt32(btArr[0].Substring(0, 2), 16).ToString().PadLeft(2, '0') + " "
                    + Convert.ToInt32(btArr[0].Substring(2, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(4, 2), 16).ToString().PadLeft(2, '0') + ":"
                    + Convert.ToInt32(btArr[0].Substring(6, 2), 16).ToString().PadLeft(2, '0') + "."
                    + Convert.ToInt32(btArr[0].Substring(8, 4), 16).ToString().PadLeft(3, '0');
                string EAS_Type = "";
                string epc = "";
                if (btArr[1] == "0")
                {
                    epc = btArr[2];
                    EAS_Type = "未报警";
                }
                else if (btArr[1] == "2")
                {
                    epc = btArr[2];
                    EAS_Type = "仿真EAS报警";
                }
                string rssi = btArr[3];
                string phase = btArr[4];
                string freq = btArr[5];

                string[] arr = new string[7];
                arr[0] = (dataGridView1.Rows.Count + 1).ToString();
                arr[1] = epc;
                arr[2] = rssi;
                arr[3] = phase;
                arr[4] = freq;
                arr[5] = EAS_Type;
                arr[6] = strtime;

                dataGridView1.Rows.Add(arr);
                //dataGridView1.Update();
            }
            else if(m.Msg == WM_SENDRESULT)
            {
                string Info = Marshal.PtrToStringAnsi(m.LParam);
                fCmdRet = Convert.ToInt32(Info, 10);
                AddCmdLog("GetChannelMessage", "获取通道消息", fCmdRet);
            }
            else
                base.DefWndProc(ref m);
        }

        #region  16进制字符串到数组之间的相互转换
        private byte[] HexStringToByteArray(string s)
        {
            s = s.Replace(" ", "");
            if ((s.Length % 2) != 0)
                s += "0";
            byte[] buffer = new byte[s.Length / 2];
            for (int i = 0; i < s.Length; i += 2)
                buffer[i / 2] = (byte)Convert.ToByte(s.Substring(i, 2), 16);
            return buffer;
        }
        private string ByteArrayToHexString(byte[] data)
        {
            StringBuilder sb = new StringBuilder(data.Length * 3);
            foreach (byte b in data)
                sb.Append(Convert.ToString(b, 16).PadLeft(2, '0').PadRight(3, ' '));
            return sb.ToString().ToUpper();
        }
        #endregion

        private string GetReturnCodeDesc(int cmdRet)
        {
            switch (cmdRet)
            {
                case 0x00:
                    return "操作成功";
                case 0x01:
                    return "命令操作数长度错误";
                case 0x02:
                    return "操作命令不支持";
                case 0x03:
                    return "操作数范围错误";
                case 0x04:
                    return "操作命令当前无法执行";
                case 0x06:
                    return "FLASH操作出错";
                case 0x07:
                    return "命令执行出错";
                case 0x31:
                    return "CRC校验错误";
                case 0x30:
                    return "通讯错误";
                case 0x37:
                    return "无效的句柄";
                case 0xEE:
                    return "命令码错误";
                default:
                    return "未知错误";
            }
        }

        private void AddCmdLog(string CMD, string cmdStr, int cmdRet)
        {
            try
            {
                StatusBar1.Panels[0].Text = "";
                StatusBar1.Panels[0].Text = DateTime.Now.ToLongTimeString() + " " +
                                            cmdStr + ": " +
                                            GetReturnCodeDesc(cmdRet);
            }
            finally
            {
                ;
            }
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
           try
           {
               ConnectType con = new ConnectType();
               DialogResult result = con.ShowDialog();
               lbVersion.Text = "";
               if (result == DialogResult.OK)
               {

                   if (man.mType == 0)
                   {
                       fCmdRet = Device.OpenComWithBaudrate(man.Port,man.BaudRate, ref man.ComAddr, ref man.FrmHandle);
                   }
                   else
                   {
                       fCmdRet = Device.OpenNetPort(man.tPort, man.ipAddr, ref man.ComAddr, ref man.FrmHandle);
                   }
                   if (fCmdRet == 0)
                   {
                       byte WorkMode = 0;
                       fCmdRet = MainForm.man.GetWorkMode(ref WorkMode);
                       if (fCmdRet == 0)
                       {
                           man.WorkMode = WorkMode;
                           if (WorkMode == 0)
                           {
                               dataGridView1.Columns[0].HeaderText = "序号";
                               dataGridView1.Columns[1].HeaderText = "EPC/TID";
                               dataGridView1.Columns[2].HeaderText = "RSSI";
                               dataGridView1.Columns[3].HeaderText = "相位";
                               dataGridView1.Columns[4].HeaderText = "频点";
                               dataGridView1.Columns[5].HeaderText = "次数";
                               dataGridView1.Columns[6].HeaderText = "时间";
                           }
                           else
                           {


                               dataGridView1.Columns[0].HeaderText = "序号";
                               dataGridView1.Columns[1].HeaderText = "EPC/TID";
                               dataGridView1.Columns[2].HeaderText = "RSSI";
                               dataGridView1.Columns[3].HeaderText = "相位";
                               dataGridView1.Columns[4].HeaderText = "频点";
                               dataGridView1.Columns[5].HeaderText = "报警状态";
                               dataGridView1.Columns[6].HeaderText = "时间";
                           }
                       }

                       byte ProductCode = 0;
                       byte[] Version = new byte[2];
                       byte[] DevSN = new byte[4];
                       lbVersion.Text = "";
                       fCmdRet = Device.GetControllerInfo(ref MainForm.man.ComAddr, ref ProductCode, Version, DevSN, MainForm.man.FrmHandle);
                       if (fCmdRet == 0)
                       {
                           lbVersion.Text = "版本:"+Convert.ToString(ProductCode, 10)+"-"
                               + Convert.ToString(Version[0], 10).PadLeft(2, '0') + "." + Convert.ToString(Version[1], 10).PadLeft(2, '0')+"-"
                               + ByteArrayToHexString(DevSN).Replace(" ","");
                       }

                       EnableButton();
                   }
                   AddCmdLog("Connect", "连接设备", fCmdRet);
               }

           }
           catch (System.Exception ex)
           {
               ex.ToString();
           }
        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            try
            {
                beginScan = false;
                //timer1.Enabled = false;
                timer2.Enabled = false;
                if (man.mType == 0)
                {
                    if (man.FrmHandle > 0)
                    {
                        int result = Device.CloseSpecComPort(man.FrmHandle);
                        DisableButton();
                        man.isConnect = false;
                        man.FrmHandle = -1;
                        lbVersion.Text = "";
                        dataGridView1.Rows.Clear();
                    }
                }
                else
                {
                    if (man.FrmHandle > 0)
                    {
                        int result = Device.CloseNetPort(man.FrmHandle);
                        DisableButton();
                        man.isConnect = false;
                        man.FrmHandle = -1;
                        lbVersion.Text = "";
                        dataGridView1.Rows.Clear();
                    }
                }
            }
            catch (System.Exception ex)
            {
                dataGridView1.Rows.Clear();
                lbVersion.Text = "";
                ex.ToString();
            }
            
        }

        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            ConfigForm cf = new ConfigForm();
            cf.gbView1 = dataGridView1;
            cf.ShowDialog();
        }


        private void toolStripButton4_Click(object sender, EventArgs e)
        {
            Close();
        }
       


        public void DisableButton()
        {
            btConnect.Enabled = true;
            btDisConnect.Enabled = false;
            btConfig.Enabled = false;
            btStart.Enabled = false;
            btStop.Enabled = false;
            btLoaddefault.Enabled = false;
            btRestart.Enabled = false;
            //btUpdate.Enabled = false;

        }

        public void EnableButton()
        {
            btConnect.Enabled = false;
            btDisConnect.Enabled = true;
            btConfig.Enabled = true;
            btStart.Enabled = true;
            btStop.Enabled = false;
            btLoaddefault.Enabled = true;
            btRestart.Enabled = true;
            //btUpdate.Enabled = true;
        }
        private void Form1_Load(object sender, EventArgs e)
        {
            lbonline.Width = 300;
            dataGridView1.Width = this.Width - 300;
            dataGridView1.Columns[0].Width = ((dataGridView1.Width - 50) / 10);
            dataGridView1.Columns[1].Width = ((dataGridView1.Width - 50) / 10) * 3;
            dataGridView1.Columns[2].Width = ((dataGridView1.Width - 50) / 10) * 1;
            dataGridView1.Columns[3].Width = ((dataGridView1.Width - 50) / 10) * 1;
            dataGridView1.Columns[4].Width = ((dataGridView1.Width - 50) / 10) * 1;
            dataGridView1.Columns[5].Width = ((dataGridView1.Width - 50) / 10) * 1;
            dataGridView1.Columns[6].Width = ((dataGridView1.Width - 50) / 10) * 2;
            dataGridView1.Height = this.Height - 74;
            DisableButton();
           
        }

        private void MainForm_Resize(object sender, EventArgs e)
        {
            try
            {
                ///正常大小
                if (this.WindowState == FormWindowState.Normal)
                {
                    this.ShowInTaskbar = true; //在任务栏中不显示此窗体    
                    this.MaximizeBox = true;
                    //  this.WindowState = FormWindowState.Maximized;
                }
                lbonline.Width = 300;
                dataGridView1.Width = this.Width - 300;
                dataGridView1.Columns[0].Width = ((dataGridView1.Width - 50) / 10);
                dataGridView1.Columns[1].Width = ((dataGridView1.Width - 50) / 10) * 3;
                dataGridView1.Columns[2].Width = ((dataGridView1.Width - 50) / 10) * 1;
                dataGridView1.Columns[3].Width = ((dataGridView1.Width - 50) / 10) * 1;
                dataGridView1.Columns[4].Width = ((dataGridView1.Width - 50) / 10) * 1;
                dataGridView1.Columns[5].Width = ((dataGridView1.Width - 50) / 10) * 1;
                dataGridView1.Columns[6].Width = ((dataGridView1.Width - 50) / 10) * 2;
                dataGridView1.Height = this.Height - 74;
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
        }

        Button bt = new Button();

        private void bt_Click(object sender, EventArgs e)
        {
            if(bt.Text =="显示")
            {
                bt.Text = "隐藏";
                dataGridView1.Columns[5].Visible = true;
                dataGridView1.Columns[6].Visible = true;
                dataGridView1.Columns[9].Visible = true;
                dataGridView1.Columns[10].Visible = true;
                dataGridView1.Columns[11].Visible = true;
                dataGridView1.Columns[12].Visible = true;
                dataGridView1.Columns[13].Visible = true;
            }
            else
            {
                bt.Text = "显示";
                dataGridView1.Columns[5].Visible = false;
                dataGridView1.Columns[6].Visible = false;
                dataGridView1.Columns[9].Visible = false;
                dataGridView1.Columns[10].Visible = false;
                dataGridView1.Columns[11].Visible = false;
                dataGridView1.Columns[12].Visible = false;
                dataGridView1.Columns[13].Visible = false;
            }
        }

        private void toolStripButton5_Click(object sender, EventArgs e)
        {
            timer2.Enabled = false;
            beginScan = false;
        }

     

       

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {

        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {

        }

        volatile bool beginScan = false;
        long beginTime = 0;
        bool SendAck=false;
        Thread readThread1 = null;
        private void btStart_Click(object sender, EventArgs e)
        {
            btrefresh_Click(null,null);
            btConfig.Enabled = false;
            btStart.Enabled = false;
            btStop.Enabled = true;
            btLoaddefault.Enabled = false;
            btRestart.Enabled = false;
            beginScan = true;
            btUpdate.Enabled = false;
            //timer1.Enabled = true;
            isRuning = false;
            timer2.Enabled = true;

            SendAck = CheckAnswerACK();
            beginTime = System.Environment.TickCount;
            readThread1 = new Thread(GetMessage);
            readThread1.IsBackground = true;
            readThread1.Start();
        }

        private bool CheckAnswerACK()
        {
            byte MsgAutoUpload = 0;
            byte MsgAck = 0;
            try
            {
                fCmdRet = man.GetMsgTran(ref MsgAutoUpload, ref MsgAck);
                if (fCmdRet == 0)
                {
                    if (MsgAck == 1)
                        return true;
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }
            return false;
        }

        private void btTcpConfig_Click(object sender, EventArgs e)
        {

        }

        private void btrefresh_Click(object sender, EventArgs e)
        {
            IntPtr ptrWnd1 = IntPtr.Zero;
            ptrWnd1 = FindWindow(null, "UHFGate 演示软件 V1.0.1");
            if (ptrWnd1 != IntPtr.Zero)        
            {
                SendMessage(ptrWnd1, WM_SENDCLEAR, IntPtr.Zero, "");
            }
        }

        public class MessageType
        {
            public int MsgType;
            public int MsgLength;
            public byte[] MsgData = new byte[256];
        }
        List<MessageType> msgList = new List<MessageType>();
        List<MessageType> curList = new List<MessageType>();
        private void GetMessage()
        {
            try
            {
                byte[] Msg = new byte[256];
                byte MsgLength;
                byte MsgNum;
                byte PacketNo;

                
               
                while (beginScan)
                {
                    MsgLength = 0;
                    MsgNum = 0;
                    PacketNo = 0;
                    fCmdRet = Device.GetChannelAdvMessage(man.ComAddr, ref PacketNo,ref MsgNum, Msg,ref MsgLength,  man.FrmHandle);
                    if ((fCmdRet == 0) && (MsgLength>0))
                    {
                        if (MsgNum>0)
                        {
                            int index=0;
                            
                            for (int i = 0; i < MsgNum;i++ )
                            {
                                int packetLen = Msg[index];
                                index++;
                                int msgType = Msg[index];
                                index++;
                                byte[]MsgData = new byte[packetLen-1];
                                Array.Copy(Msg,index,MsgData,0,MsgData.Length);
                                index+=MsgData.Length;
                                MessageType MsgType = new MessageType();
                                MsgType.MsgType = msgType;
                                MsgType.MsgLength = MsgData.Length;
                                Array.Copy(MsgData, 0, MsgType.MsgData, 0, MsgData.Length);
                                lock (LockFlag)
                                {
                                    curList.Add(MsgType);
                                }
                               // parseMsg(msgType, MsgData.Length, MsgData, ptrWnd1);
                            }
                        }
                        if (SendAck)
                            Device.Acknowledge(man.ComAddr, man.FrmHandle);
                    }
                }
            }
            catch (System.Exception ex)
            {
                ex.ToString();
            }

            this.Invoke((EventHandler)delegate
            {
                if( man.FrmHandle >0)
                {
                    btConfig.Enabled = true;
                    btStart.Enabled = true;
                    btStop.Enabled = false;
                    btLoaddefault.Enabled = true;
                    btRestart.Enabled = true;
                    timer2.Enabled = false;
                    btUpdate.Enabled = true;
                }
            });
          
        }

        private void parseMsg(int MsgType, int msgLen, byte[] Msg, IntPtr ptrWnd1)
        {
            if (MsgType == 0)//空消息响应,不处理
            {
                ;
            }
            else if (MsgType == 1)//盘存消息响应
            {
                byte[] AyTime = new byte[6];
                Array.Copy(Msg, 0, AyTime, 0, 6);//时间
                int Number = Msg[6];//张数
                if (Number == 1)
                {
                    int EPCLen = Msg[7];//EPC号长度
                    byte[] EPC = new byte[EPCLen];
                    Array.Copy(Msg, 8, EPC, 0, EPCLen);//标签的EPC号

                    if (ptrWnd1 != IntPtr.Zero)
                    {
                        string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                        para += ",";
                        para += ByteArrayToHexString(EPC);
                        SendMessage(ptrWnd1, WM_SENDTAG, IntPtr.Zero, para);
                    }
                }

            }
            else if (MsgType == 2)//EAS报警消息响应
            {
                byte[] AyTime = new byte[6];
                Array.Copy(Msg, 0, AyTime, 0, 6);//时间
                int EAS_Type = Msg[6];//消息类型,0-未报警，2-报警
                if ((EAS_Type == 0) || (EAS_Type == 2))
                {
                    int EPCLen = Msg[7];//EPC号长度
                    byte[] EPC = new byte[EPCLen];
                    Array.Copy(Msg, 8, EPC, 0, EPCLen);//EPC号
                    if (ptrWnd1 != IntPtr.Zero)    
                    {
                        string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                        para += ",";
                        para += EAS_Type.ToString();
                        para += ",";
                        para += ByteArrayToHexString(EPC);
                        SendMessage(ptrWnd1, WM_SENDEAS, IntPtr.Zero, para);
                    }
                }
                else//标准EAS报警
                {
                    if (ptrWnd1 != IntPtr.Zero)  
                    {
                        string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                        para += ",";
                        para += EAS_Type.ToString();
                        SendMessage(ptrWnd1, WM_SENDEAS, IntPtr.Zero, para);
                    }
                }
            }
            else if (MsgType == 3)//人员消息响应
            {
                byte[] AyTime = new byte[6];
                Array.Copy(Msg, 0, AyTime, 0, 6);//时间
                int dir_Type = Msg[6];//方向

                int positive = (Msg[7] << 24) + (Msg[8] << 16) + (Msg[9] << 8) + Msg[10];//正向
                int reverse = (Msg[11] << 24) + (Msg[12] << 16) + (Msg[13] << 8) + Msg[14];//反向
                int Online = (Msg[15] << 24) + (Msg[16] << 16) + (Msg[17] << 8) + Msg[18];//在馆人数

                if (ptrWnd1 != IntPtr.Zero)         // 检查当前统计窗口是否打开
                {
                    string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                    para += ",";
                    para += dir_Type.ToString();
                    para += ",";
                    para += positive.ToString();
                    para += ",";
                    para += reverse.ToString();
                    para += ",";
                    para += Online.ToString();
                    SendMessage(ptrWnd1, WM_SENDPERSON, IntPtr.Zero, para);
                }

            }
            else if (MsgType == 4)//红外消息响应
            {
                byte[] AyTime = new byte[6];
                Array.Copy(Msg, 0, AyTime, 0, 6);//时间
                int Num = Msg[6];//红外编号
                int IRactive = Msg[7];//红外动作(遮挡或)

                if (ptrWnd1 != IntPtr.Zero)         // 检查当前统计窗口是否打开
                {
                    string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                    para += ",";
                    para += Num.ToString();
                    para += ",";
                    para += IRactive.ToString();
                    SendMessage(ptrWnd1, WM_SENDIR, IntPtr.Zero, para);
                }
            }
            else if (MsgType == 5)//盘存消息格式二
            {
                byte[] AyTime = new byte[6];
                Array.Copy(Msg, 0, AyTime, 0, 6);//时间
                int Number = Msg[6];//张数
                if (Number == 1)
                {
                    int EPCLen = Msg[7];//EPC号长度
                    byte[] EPC = new byte[EPCLen];
                    Array.Copy(Msg, 8, EPC, 0, EPCLen);//标签的EPC号
                    int rssi = Msg[8 + EPCLen];
                    if (ptrWnd1 != IntPtr.Zero)
                    {
                        string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                        para += ",";
                        para += ByteArrayToHexString(EPC);
                        para += ",";
                        para += (rssi+"");
                        SendMessage(ptrWnd1, WM_SENDINVRSSI, IntPtr.Zero, para);
                    }
                }
            }
            if (MsgType == 6)//EAS报警消息格式二
            {
                byte[] AyTime = new byte[6];
                Array.Copy(Msg, 0, AyTime, 0, 6);//时间
                int EAS_Type = Msg[6];//消息类型,0-未报警，2-报警
                if ((EAS_Type == 0) || (EAS_Type == 2))
                {
                    int EPCLen = Msg[7];//EPC号长度
                    byte[] EPC = new byte[EPCLen];
                    Array.Copy(Msg, 8, EPC, 0, EPCLen);//EPC号
                    int rssi = Msg[8 + EPCLen];
                    if (ptrWnd1 != IntPtr.Zero)
                    {
                        string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                        para += ",";
                        para += EAS_Type.ToString();
                        para += ",";
                        para += ByteArrayToHexString(EPC);
                        para += ",";
                        para += (rssi + "");
                        SendMessage(ptrWnd1, WM_SENDEASRSSI, IntPtr.Zero, para);
                    }
                }
            }
            else if (MsgType == 7)//盘存消息格式二
            {
                byte[] AyTime = new byte[6];
                Array.Copy(Msg, 0, AyTime, 0, 6);//时间
                int Number = Msg[6];//张数
                if (Number == 1)
                {
                    int EPCLen = Msg[7];//EPC号长度
                    byte[] EPC = new byte[EPCLen];
                    Array.Copy(Msg, 8, EPC, 0, EPCLen);//标签的EPC号
                    int rssi = Msg[8 + EPCLen];
                    int phase = Msg[9 + EPCLen] * 256 + Msg[10 + EPCLen];
                    int Freq = (Msg[13 + EPCLen] <<16) + (Msg[14 + EPCLen] <<8)+Msg[15 + EPCLen];
                    if (ptrWnd1 != IntPtr.Zero)
                    {
                        string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                        para += ",";
                        para += ByteArrayToHexString(EPC);
                        para += ",";
                        para += (rssi + "");
                        para += ",";
                        para += String.Format("{0:N3}", phase * 0.08789f % 180);
                        para += ",";
                        para += (Freq + "");
                        SendMessage(ptrWnd1, WM_SENDINVPHASE, IntPtr.Zero, para);
                    }
                }
            }
            if (MsgType == 8)//EAS报警消息格式二
            {
                byte[] AyTime = new byte[6];
                Array.Copy(Msg, 0, AyTime, 0, 6);//时间
                int EAS_Type = Msg[6];//消息类型,0-未报警，2-报警
                if ((EAS_Type == 0) || (EAS_Type == 2))
                {
                    int EPCLen = Msg[7];//EPC号长度
                    byte[] EPC = new byte[EPCLen];
                    Array.Copy(Msg, 8, EPC, 0, EPCLen);//EPC号
                    int rssi = Msg[8 + EPCLen];
                    int phase = Msg[9 + EPCLen] * 256 + Msg[10 + EPCLen];
                    int Freq = (Msg[13 + EPCLen] << 16) + (Msg[14 + EPCLen] << 8) + Msg[15 + EPCLen];
                    if (ptrWnd1 != IntPtr.Zero)
                    {
                        string para = ByteArrayToHexString(AyTime).Replace(" ", "");
                        para += ",";
                        para += EAS_Type.ToString();
                        para += ",";
                        para += ByteArrayToHexString(EPC);
                        para += ",";
                        para += (rssi + "");
                        para += ",";
                        para += String.Format("{0:N3}", phase * 0.08789f % 180);
                        para += ",";
                        para += (Freq + "");
                        SendMessage(ptrWnd1, WM_SENEASPHASE, IntPtr.Zero, para);
                    }
                }
            }
        }

        bool isRuning = false;
        private void timer2_Tick(object sender, EventArgs e)
        {
            if (isRuning) return;
            isRuning = true;

            long runTime = System.Environment.TickCount - beginTime;
            long millsecond = runTime % 1000;
            long totalsecond = (runTime / 1000);
            long minute = (totalsecond / 60);
            long second = totalsecond % 60;
            txtTime.Text = minute.ToString().PadLeft(2, '0') + ":" + second.ToString().PadLeft(2, '0') + ":" + millsecond.ToString().PadLeft(3, '0');
            MessageType[] myMsg = new MessageType[256];
            int Count = 0;
            lock(LockFlag)
            {
                Count = curList.Count;
                myMsg = new MessageType[Count];
                if (Count > 0)
                {
                    curList.CopyTo(myMsg, 0);
                }
                curList.Clear();
            }
            IntPtr ptrWnd1 = IntPtr.Zero;
                ptrWnd1 = FindWindow(null, "UHFGate 演示软件 V1.0.1");
            for (int p = 0; p < Count; p++)
            {
                MessageType mMsg = myMsg[p];
                parseMsg(mMsg.MsgType, mMsg.MsgLength, mMsg.MsgData, ptrWnd1);
            }
            isRuning = false;
        }

        private void toolStrip1_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {

        }

        private void btLoaddefault_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show(this, "恢复出厂设置以后可能需要重启软件，确定要执行此操作吗", "信息提示", MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                return;
            fCmdRet = Device.LoadDefault(man.ComAddr, man.FrmHandle);
            AddCmdLog("LoadDefault", "恢复出厂设置", fCmdRet);
        }

        private void btRestart_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show(this, "设备重启以后可能需要重启软件，确定要执行此操作吗", "信息提示", MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                return;
            fCmdRet = Device.ControllerRestart(man.ComAddr, man.FrmHandle);
            AddCmdLog("ControllerRestart", "设备重启", fCmdRet);
        }

        private void btUpdate_Click(object sender, EventArgs e)
        {
            updateForm up = new updateForm();
            up.ShowDialog();
        }

    }
}