﻿using System;
using System.Collections.Generic;
using System.Text;
using Gate;
namespace UHFGateDemo
{
    public class Manager
    {
        public int FrmHandle;
        public byte ComAddr;
        public int Port;
        public byte BaudRate;
        public string ipAddr;
        public int tPort;
        public byte ChannelMode;
        public int mType;
        public bool isConnect;

        public int WorkMode = 0;

        public int SetControllAddr(byte NewComAddr)
        {
            byte CFGNo = 1;
            byte CFGLen = 1;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = NewComAddr;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetControllAddr(ref byte NewComAddr)
        {
            byte CFGNo = 1;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo,ref CFGLen, CFGData, FrmHandle);
            if (result==0)
            {
                NewComAddr = CFGData[0];
            }
            return result;
        }


        public int SetWorkMode(byte WorkMode)
        {
            byte CFGNo = 2;
            byte CFGLen = 1;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = WorkMode;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetWorkMode(ref byte WorkMode)
        {
            byte CFGNo = 2;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                WorkMode = CFGData[0];
            }
            return result;
        }

        public int SetAlarmType(byte AlarmMode,byte AlarmType)
        {
            byte CFGNo = 3;
            byte CFGLen = 2;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = AlarmMode;
            CFGData[1] = AlarmType;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetAlarmType(ref byte AlarmMode,ref byte AlarmType)
        {
            byte CFGNo = 3;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                AlarmMode = CFGData[0];
                AlarmType = CFGData[1];
            }
            return result;
        }

        public int SetActionEn(byte[] action)
        {
            byte CFGNo = 4;
            byte CFGLen = 4;
            byte[] CFGData = new byte[CFGLen];
            Array.Copy(action, 0, CFGData, 0, 4);
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetActionEn(byte[] action)
        {
            byte CFGNo = 4;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            Array.Copy(action, 0, CFGData, 0, 4);
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                Array.Copy(CFGData, 0, action, 0, 4);
            }
            return result;
        }

        public int SetCustomAlarmRules(byte[] MaskEn, byte[] MaskData, byte MinLen, byte MaxLen)
        {
            byte CFGNo = 5;
            byte CFGLen = 128;
            byte[] CFGData = new byte[CFGLen];
            Array.Copy(MaskEn, 0, CFGData, 0, 62);
            Array.Copy(MaskData, 0, CFGData, 62, 62);
            CFGData[124] = MinLen;
            CFGData[125] = MaxLen;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetCustomAlarmRules(byte[] MaskEn, byte[] MaskData,ref byte MinLen,ref byte MaxLen)
        {
            byte CFGNo = 5;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                Array.Copy(CFGData, 0, MaskEn, 0, 62);
                Array.Copy(CFGData, 62, MaskData, 0, 62);
                MinLen = CFGData[124];
                MaxLen = CFGData[125];
            }
            return result;
        }

        public int SetAlarmEventAction(byte BuzzOpenT, byte BuzzcloseT, byte BuzzCnt, byte BuzzVol, byte LEDEn, byte LEDOpenT, byte LEDCloseT, byte LEDCnt,
            byte Relay1T, byte Relay2T, byte BeepT)
        {
            byte CFGNo = 6;
            byte CFGLen = 16;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = BuzzOpenT;
            CFGData[1] = BuzzcloseT;
            CFGData[2] = BuzzCnt;
            CFGData[3] = BuzzVol;
            CFGData[4] = LEDEn;
            CFGData[5] = LEDOpenT;
            CFGData[6] = LEDCloseT;
            CFGData[7] = LEDCnt;
            CFGData[8] = Relay1T;
            CFGData[9] = Relay2T;
            CFGData[10] = BeepT;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetAlarmEventAction(ref byte BuzzOpenT, ref byte BuzzcloseT, ref byte BuzzCnt, ref byte BuzzVol, ref byte LEDEn, ref byte LEDOpenT, ref byte LEDCloseT, ref byte LEDCnt,
            ref byte Relay1T, ref byte Relay2T, ref byte BeepT)
        {
            byte CFGNo = 6;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                BuzzOpenT = CFGData[0];
                BuzzcloseT = CFGData[1];
                BuzzCnt = CFGData[2];
                BuzzVol = CFGData[3];
                LEDEn = CFGData[4];
                LEDOpenT = CFGData[5];
                LEDCloseT = CFGData[6];
                LEDCnt = CFGData[7];
                Relay1T = CFGData[8];
                Relay2T = CFGData[9];
                BeepT = CFGData[10];
            }
            return result;
        }

        public int SetMsgEn(byte PersionEn, byte IREn, byte NoALarmEn)
        {
            byte CFGNo = 7;
            byte CFGLen = 4;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] =(byte) (PersionEn | (IREn << 1) | (NoALarmEn << 2));
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetMsgEn(ref byte PersionEn, ref byte IREn, ref byte NoALarmEn)
        {
            byte CFGNo = 7;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                PersionEn = (byte)(CFGData[0] & 0x01);
                IREn = (byte)((CFGData[0]>>1) & 0x01);
                NoALarmEn = (byte)((CFGData[0]>>2) & 0x01);
            }
            return result;
        }

        public int SetMsgTran(byte MsgAutoUpload, byte MsgAck)
        {
            byte CFGNo = 8;
            byte CFGLen = 2;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = MsgAutoUpload;
            CFGData[1] = MsgAck;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetMsgTran(ref byte MsgAutoUpload, ref byte MsgAck)
        {
            byte CFGNo = 8;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                MsgAutoUpload = CFGData[0];
                MsgAck = CFGData[1];
            }
            return result;
        }

        public int SetDirection(byte Direction)
        {
            byte CFGNo = 9;
            byte CFGLen = 1;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = Direction;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetDirection(ref byte Direction)
        {
            byte CFGNo = 9;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                Direction = CFGData[0];
            }
            return result;
        }

        public int SetPersionEnterEventAction(byte BuzzOpenT, byte BuzzcloseT, byte BuzzCnt, byte BuzzVol, byte LEDEn, byte LEDOpenT, byte LEDCloseT, byte LEDCnt,
            byte Relay1T, byte Relay2T, byte BeepT)
        {
            byte CFGNo = 10;
            byte CFGLen = 16;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = BuzzOpenT;
            CFGData[1] = BuzzcloseT;
            CFGData[2] = BuzzCnt;
            CFGData[3] = BuzzVol;
            CFGData[4] = LEDEn;
            CFGData[5] = LEDOpenT;
            CFGData[6] = LEDCloseT;
            CFGData[7] = LEDCnt;
            CFGData[8] = Relay1T;
            CFGData[9] = Relay2T;
            CFGData[10] = BeepT;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetPersionEnterEventAction(ref byte BuzzOpenT, ref byte BuzzcloseT, ref byte BuzzCnt, ref byte BuzzVol, ref byte LEDEn, ref byte LEDOpenT, ref byte LEDCloseT, ref byte LEDCnt,
            ref byte Relay1T, ref byte Relay2T, ref byte BeepT)
        {
            byte CFGNo = 10;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                BuzzOpenT = CFGData[0];
                BuzzcloseT = CFGData[1];
                BuzzCnt = CFGData[2];
                BuzzVol = CFGData[3];
                LEDEn = CFGData[4];
                LEDOpenT = CFGData[5];
                LEDCloseT = CFGData[6];
                LEDCnt = CFGData[7];
                Relay1T = CFGData[8];
                Relay2T = CFGData[9];
                BeepT = CFGData[10];
            }
            return result;
        }

        public int SetPersionLeaveEventAction(byte BuzzOpenT, byte BuzzcloseT, byte BuzzCnt, byte BuzzVol, byte LEDEn, byte LEDOpenT, byte LEDCloseT, byte LEDCnt,
            byte Relay1T, byte Relay2T, byte BeepT)
        {
            byte CFGNo = 11;
            byte CFGLen = 16;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = BuzzOpenT;
            CFGData[1] = BuzzcloseT;
            CFGData[2] = BuzzCnt;
            CFGData[3] = BuzzVol;
            CFGData[4] = LEDEn;
            CFGData[5] = LEDOpenT;
            CFGData[6] = LEDCloseT;
            CFGData[7] = LEDCnt;
            CFGData[8] = Relay1T;
            CFGData[9] = Relay2T;
            CFGData[10] = BeepT;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetPersionLeaveEventAction(ref byte BuzzOpenT, ref byte BuzzcloseT, ref byte BuzzCnt, ref byte BuzzVol, ref byte LEDEn, ref byte LEDOpenT, ref byte LEDCloseT, ref byte LEDCnt,
            ref byte Relay1T, ref byte Relay2T, ref byte BeepT)
        {
            byte CFGNo = 11;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                BuzzOpenT = CFGData[0];
                BuzzcloseT = CFGData[1];
                BuzzCnt = CFGData[2];
                BuzzVol = CFGData[3];
                LEDEn = CFGData[4];
                LEDOpenT = CFGData[5];
                LEDCloseT = CFGData[6];
                LEDCnt = CFGData[7];
                Relay1T = CFGData[8];
                Relay2T = CFGData[9];
                BeepT = CFGData[10];
            }
            return result;
        }

        public int SetIrTriggerEn(byte InfraredTrigEn, byte DelayTime)
        {
            byte CFGNo = 12;
            byte CFGLen = 2;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = InfraredTrigEn;
            CFGData[1] = DelayTime;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetIrTriggerEn(ref byte InfraredTrigEn, ref byte DelayTime)
        {
            byte CFGNo = 12;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                InfraredTrigEn = CFGData[0];
                DelayTime = CFGData[1];
            }
            return result;
        }

        

        public int SetFilterTime(byte FliterTime)
        {
            byte CFGNo = 13;
            byte CFGLen = 1;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = FliterTime;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetFilterTime(ref byte FliterTime)
        {
            byte CFGNo = 13;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                FliterTime = CFGData[0];
            }
            return result;
        }



        public int SetInventoryType(byte InventoryType)
        {
            byte CFGNo = 30;
            byte CFGLen = 1;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = InventoryType;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetInventoryType(ref byte InventoryType)
        {
            byte CFGNo = 30;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                InventoryType = CFGData[0];
            }
            return result;
        }

        public int SetInventoryParam(byte QValue, byte Session)
        {
            byte CFGNo = 31;
            byte CFGLen = 2;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = QValue;
            CFGData[1] = Session;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetInventoryParam(ref byte QValue,ref byte Session)
        {
            byte CFGNo = 31;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                QValue = CFGData[0];
                Session = CFGData[1];
            }
            return result;
        }


        public int SetTIDParam(byte FirstAddr, byte Length)
        {
            byte CFGNo = 32;
            byte CFGLen = 2;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = FirstAddr;
            CFGData[1] = Length;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetTIDParam(ref byte FirstAddr, ref byte Length)
        {
            byte CFGNo = 32;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                FirstAddr = CFGData[0];
                Length = CFGData[1];
            }
            return result;
        }

        public int SetMaskParam(byte MaskEn, byte MaskMem, byte[] MaskAddr, byte MaskLen, byte[] MaskData)
        {
            byte CFGNo = 33;
            byte CFGLen = 37;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = MaskEn;
            CFGData[1] = MaskMem;
            Array.Copy(MaskAddr, 0, CFGData, 2, 2);
            CFGData[4] = MaskLen;
            Array.Copy(MaskData, 0, CFGData,5,32);
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetMaskParam(ref byte MaskEn,ref byte MaskMem, byte[] MaskAddr, ref byte MaskLen, byte[] MaskData)
        {
            byte CFGNo = 33;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                MaskEn = CFGData[0];
                MaskMem = CFGData[1];
                Array.Copy(CFGData, 2, MaskAddr, 0, 2);
                MaskLen = CFGData[4];
                Array.Copy(CFGData, 5, MaskData, 0, 32);
            }
            return result;
        }

        public int SetRegion(byte FreqBand, byte MaxFre, byte MinFre)
        {
            byte CFGNo = 34;
            byte CFGLen = 3;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = FreqBand;
            CFGData[1] = MaxFre;
            CFGData[2] = MinFre;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetRegion(ref byte FreqBand,ref byte MaxFre,ref byte MinFre)
        {
            byte CFGNo = 34;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                FreqBand = CFGData[0];
                MaxFre = CFGData[1];
                MinFre = CFGData[2];
            }
            return result;
        }


        public int SetReaderPower(byte[]Power)
        {
            byte CFGNo = 35;
            byte CFGLen = 8;
            byte[] CFGData = new byte[CFGLen];
            Array.Copy(Power, 0, CFGData, 0, 8);
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetReaderPower(byte[]Power)
        {
            byte CFGNo = 35;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                Array.Copy(CFGData, 0, Power, 0, 8);
            }
            return result;
        }

        public int SetNetWorkIP(byte[] ipAddr, byte[] SubnetMask, byte[] wgAddr, byte dhcp)
        {
            byte CFGNo = 50;
            byte CFGLen = 16;
            byte[] CFGData = new byte[CFGLen];
            Array.Copy(ipAddr, 0, CFGData, 0, 4);
            Array.Copy(SubnetMask, 0, CFGData, 4, 4);
            Array.Copy(wgAddr, 0, CFGData, 8, 4);
            CFGData[12] = dhcp;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetNetWorkIP(byte[] ipAddr, byte[] SubnetMask, byte[] wgAddr,ref byte dhcp)
        {
            byte CFGNo = 50;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                Array.Copy(CFGData, 0, ipAddr, 0, 4);
                Array.Copy(CFGData, 4, SubnetMask, 0, 4);
                Array.Copy(CFGData, 8, wgAddr, 0, 4);
                dhcp = CFGData[12];
            }
            return result;
        }

        public int SetNetWorkConnection(byte[] SvripAddr, int SvrPOrt, byte ConnectionMode, int ClientPort)
        {
            byte CFGNo = 51;
            byte CFGLen = 9;
            byte[] CFGData = new byte[CFGLen];
            Array.Copy(SvripAddr, 0, CFGData, 0, 4);
            CFGData[4] = (byte)(SvrPOrt >> 8);
            CFGData[5] = (byte)(SvrPOrt &0x00FF);
            CFGData[6] = (byte)(ClientPort >> 8);
            CFGData[7] = (byte)(ClientPort & 0x00FF);
            CFGData[8] = ConnectionMode;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetNetWorkConnection(byte[] SvripAddr,ref int SvrPOrt,ref byte ConnectionMode,ref int ClientPort)
        {
            byte CFGNo = 51;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                Array.Copy(CFGData, 0, SvripAddr, 0, 4);
                SvrPOrt = CFGData[4]*256 + CFGData[5];
                ClientPort = CFGData[6] * 256 + CFGData[7];
                ConnectionMode = CFGData[8];
            }
            return result;
        }

        public int SetTimeoutAndReconnect(int TCPTimeOut, byte TCPReconnectMode)
        {
            byte CFGNo = 52;
            byte CFGLen = 4;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = (byte)(TCPTimeOut >> 8);
            CFGData[1] = (byte)(TCPTimeOut & 0x00FF);
            CFGData[2] = TCPReconnectMode;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetTimeoutAndReconnect(ref int TCPTimeOut,ref byte TCPReconnectMode)
        {
            byte CFGNo = 52;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                TCPTimeOut = CFGData[0] * 256 + CFGData[1];
                TCPReconnectMode = CFGData[2];
            }
            return result;
        }


        public int SetActiveAntenna(byte antenna)
        {
            byte CFGNo = 36;
            byte CFGLen = 1;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = antenna;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetActiveAntenna(ref byte antenna)
        {
            byte CFGNo = 36;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                antenna = CFGData[0];
            }
            return result;
        }

        public int SetRSSIAndPhase(byte rssi_phase,byte rfu)
        {
            byte CFGNo = 37;
            byte CFGLen = 2;
            byte[] CFGData = new byte[CFGLen];
            CFGData[0] = rssi_phase;
            CFGData[1] = rfu;
            return Device.ConfigureController(ComAddr, CFGNo, CFGLen, CFGData, FrmHandle);
        }

        public int GetRSSIAndPhase(ref byte rssi_phase, ref byte rfu)
        {
            byte CFGNo = 37;
            byte CFGLen = 255;
            byte[] CFGData = new byte[CFGLen];
            int result = Device.GetControllerConfig(ComAddr, CFGNo, ref CFGLen, CFGData, FrmHandle);
            if (result == 0)
            {
                rssi_phase = CFGData[0];
                rfu = CFGData[1];
            }
            return result;
        }
    }
}
